/*
 * Decompiled with CFR 0.152.
 */
package eduni.distributions;

import eduni.distributions.Distributions;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Calendar;
import javax.swing.JOptionPane;

public class MetaGenerator {
    String[] params;
    String methodName;
    String className;
    int nbC;

    public MetaGenerator(String string, int n) {
        this.methodName = string;
        this.className = string.substring(0, 1).toUpperCase() + string.substring(1);
        this.nbC = n;
    }

    public void generate() {
        try {
            String string = "eduni/distributions/" + this.className + ".java";
            PrintWriter printWriter = new PrintWriter(new FileWriter(string));
            Distributions distributions = new Distributions();
            Class<?> clazz = distributions.getClass();
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = 0;
            while (n < methodArray.length) {
                if (methodArray[n].getName().equals(this.methodName)) {
                    this.generate(printWriter, methodArray[n]);
                    break;
                }
                ++n;
            }
            printWriter.close();
            System.out.println("File " + string + " successfully generated.");
            System.exit(0);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public boolean generate(PrintWriter printWriter, Method method) {
        printWriter.println("package eduni.distributions;\n");
        printWriter.println("/** Automatically generated by MetaGenerator.");
        printWriter.print("  * A random number generator based on the ");
        printWriter.print(this.methodName);
        printWriter.println(" distribution.");
        printWriter.println("  * @version 1.0, " + Calendar.getInstance().getTime());
        printWriter.println("  * @author F.Mallet from C.Simatos's original");
        printWriter.println("  */\n");
        printWriter.print("public class " + this.className + " extends Generator implements ");
        if (method.getReturnType().getName().equals("double")) {
            printWriter.print("Continuous");
        } else {
            printWriter.print("Discrete");
        }
        printWriter.println("Generator {");
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        Class<?>[] classArray = method.getParameterTypes();
        this.params = new String[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            this.params[n] = JOptionPane.showInputDialog("Name of the parameter " + n, (Object)("p" + n));
            printWriter.println("    private " + classArray[n].getName() + " " + this.params[n] + ";");
            stringBuffer2.append(classArray[n].getName());
            stringBuffer2.append(" ");
            stringBuffer2.append(this.params[n]);
            stringBuffer.append(this.params[n]);
            if (n + 1 < classArray.length) {
                stringBuffer2.append(", ");
                stringBuffer.append(", ");
            }
            ++n;
        }
        printWriter.println("    /**");
        printWriter.println("     * the seed is aumatically provided by the <code>SeedGenerator</code>");
        printWriter.println("     */");
        printWriter.println("    public " + this.className + "(" + stringBuffer2 + ") {");
        printWriter.println("        super();");
        printWriter.println("        set(" + stringBuffer + ");");
        printWriter.println("    }\n");
        printWriter.println("    /**");
        printWriter.println("     * The constructor with which a specific seed is set for the random");
        printWriter.println("     * number generator");
        printWriter.println("     * @param seed The initial seed for the generator, two instances with");
        printWriter.println("     *             the same seed will generate the same sequence of numbers");
        printWriter.println("     */");
        printWriter.println("    public " + this.className + "(" + stringBuffer2 + ", long seed) {");
        printWriter.println("        super(seed);");
        printWriter.println("        set(" + stringBuffer + ");");
        printWriter.println("    }\n");
        printWriter.println("    private void set(" + stringBuffer2 + ") {");
        int n2 = 0;
        while (n2 < this.nbC) {
            String string = JOptionPane.showInputDialog("Enter constraint violation " + n2 + "/" + this.nbC, (Object)"a<=0");
            String string2 = JOptionPane.showInputDialog("Error message when " + string);
            printWriter.println("        if (" + string + ")");
            printWriter.println("            throw new ParameterException(\"" + this.className + ": " + string2 + ".\");");
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.params.length) {
            printWriter.println("        this." + this.params[n3] + " = " + this.params[n3] + ";");
            ++n3;
        }
        printWriter.println("    }\n");
        printWriter.println("    /**");
        printWriter.println("     * Generate a new random number.");
        printWriter.println("     * @return The next random number in the sequence");
        printWriter.println("     */");
        printWriter.println("    public " + method.getReturnType().getName() + " sample() { ");
        printWriter.println("         return distrib." + this.methodName + "(" + stringBuffer + ");");
        printWriter.println("    }\n}");
        return true;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java MetaGenerator <distrib_name> [#<nb_constraints>]");
            System.exit(1);
        }
        int n = 0;
        try {
            if (stringArray.length > 1) {
                n = Integer.parseInt(stringArray[1]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        new MetaGenerator(stringArray[0], n).generate();
    }
}

