/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.Classifier;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelVector;
import cc.mallet.types.Labeling;

public class Classification {
    Instance instance;
    Classifier classifier;
    Labeling labeling;

    public Classification(Instance instance, Classifier classifier, Labeling labeling) {
        this.instance = instance;
        this.classifier = classifier;
        this.labeling = labeling;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public Classifier getClassifier() {
        return this.classifier;
    }

    public Labeling getLabeling() {
        return this.labeling;
    }

    public LabelVector getLabelVector() {
        return this.labeling.toLabelVector();
    }

    public boolean bestLabelIsCorrect() {
        Labeling correctLabeling = this.instance.getLabeling();
        if (correctLabeling == null) {
            throw new IllegalStateException("Instance has no label.");
        }
        return this.labeling.getBestLabel().equals(correctLabeling.getBestLabel());
    }

    public double valueOfCorrectLabel() {
        Labeling correctLabeling = this.instance.getLabeling();
        int correctLabelIndex = correctLabeling.getBestIndex();
        return this.labeling.value(correctLabelIndex);
    }

    public void print() {
        System.out.print(this.classifier.getClass().getName() + "(.");
        System.out.print(") = [");
        for (int i = 0; i < this.labeling.numLocations(); ++i) {
            System.out.print(this.labeling.labelAtLocation(i).toString() + "=" + this.labeling.valueAtLocation(i) + " ");
        }
        System.out.println("]");
    }
}

