/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import java.util.ArrayList;

public class InvertedIndex {
    InstanceList ilist;
    ArrayList[] ii;

    public InvertedIndex(InstanceList ilist) {
        int numFeatures = ilist.getDataAlphabet().size();
        this.ii = new ArrayList[numFeatures];
        for (int i = 0; i < ilist.size(); ++i) {
            Instance inst = (Instance)ilist.get(i);
            if (!(inst.getData() instanceof FeatureVector)) {
                throw new IllegalArgumentException(this.getClass().getName() + " currently only handles FeatureVector data");
            }
            FeatureVector fv = (FeatureVector)inst.getData();
            for (int fl = 0; fl < fv.numLocations(); ++fl) {
                if (fv.valueAtLocation(fl) == 0.0) continue;
                this.addEntry(fv.indexAtLocation(fl), inst);
            }
        }
    }

    private void addEntry(int featureIndex, Instance instance) {
        if (this.ii[featureIndex] == null) {
            this.ii[featureIndex] = new ArrayList(2);
        }
        this.ii[featureIndex].add(instance);
    }

    public InstanceList getInstanceList() {
        return this.ilist;
    }

    public ArrayList getInstancesWithFeature(int featureIndex) {
        return this.ii[featureIndex];
    }

    public ArrayList getInstancesWithFeature(Object feature) {
        int index = this.ilist.getDataAlphabet().lookupIndex(feature, false);
        if (index == -1) {
            throw new IllegalArgumentException("Feature " + feature + " not contained in InvertedIndex");
        }
        return this.getInstancesWithFeature(index);
    }

    public int getCountWithFeature(int featureIndex) {
        ArrayList a = this.ii[featureIndex];
        return a == null ? 0 : a.size();
    }

    public int getCountWithFeature(Object feature) {
        int index = this.ilist.getDataAlphabet().lookupIndex(feature, false);
        if (index == -1) {
            throw new IllegalArgumentException("Feature " + feature + " not contained in InvertedIndex");
        }
        ArrayList a = this.ii[index];
        return a == null ? 0 : a.size();
    }
}

