/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import cc.mallet.util.Lexer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharSequenceLexer
implements Lexer,
Serializable {
    public static final Pattern LEX_ALPHA = Pattern.compile("\\p{Alpha}+");
    public static final Pattern LEX_WORDS = Pattern.compile("\\w+");
    public static final Pattern LEX_NONWHITESPACE_TOGETHER = Pattern.compile("\\S+");
    public static final Pattern LEX_WORD_CLASSES = Pattern.compile("\\p{Alpha}+|\\p{Digit}+");
    public static final Pattern LEX_NONWHITESPACE_CLASSES = Pattern.compile("\\p{Alpha}+|\\p{Digit}+|\\p{Punct}");
    Pattern regex;
    Matcher matcher = null;
    CharSequence input;
    String matchText;
    boolean matchTextFresh;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public CharSequenceLexer() {
        this(LEX_ALPHA);
    }

    public CharSequenceLexer(Pattern regex) {
        this.regex = regex;
        this.setCharSequence(null);
    }

    public CharSequenceLexer(String regex) {
        this(Pattern.compile(regex));
    }

    public CharSequenceLexer(CharSequence input, Pattern regex) {
        this(regex);
        this.setCharSequence(input);
    }

    public CharSequenceLexer(CharSequence input, String regex) {
        this(input, Pattern.compile(regex));
    }

    public void setCharSequence(CharSequence input) {
        this.input = input;
        this.matchText = null;
        this.matchTextFresh = false;
        if (input != null) {
            this.matcher = this.regex.matcher(input);
        }
    }

    public CharSequence getCharSequence() {
        return this.input;
    }

    public String getPattern() {
        return this.regex.pattern();
    }

    public void setPattern(String reg) {
        if (!this.regex.equals(this.getPattern())) {
            this.regex = Pattern.compile(reg);
        }
    }

    public int getStartOffset() {
        if (this.matchText == null) {
            return -1;
        }
        return this.matcher.start();
    }

    public int getEndOffset() {
        if (this.matchText == null) {
            return -1;
        }
        return this.matcher.end();
    }

    public String getTokenString() {
        return this.matchText;
    }

    private void updateMatchText() {
        if (this.matcher != null && this.matcher.find()) {
            this.matchText = this.matcher.group();
            if (this.matchText.length() == 0) {
                this.updateMatchText();
            }
        } else {
            this.matchText = null;
        }
        this.matchTextFresh = true;
    }

    public boolean hasNext() {
        if (!this.matchTextFresh) {
            this.updateMatchText();
        }
        return this.matchText != null;
    }

    public Object next() {
        if (!this.matchTextFresh) {
            this.updateMatchText();
        }
        this.matchTextFresh = false;
        return this.matchText;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.regex.pattern());
        out.writeInt(this.regex.flags());
        out.writeBoolean(this.matchTextFresh);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 0) {
            this.regex = (Pattern)in.readObject();
        } else if (version == 1) {
            String p = (String)in.readObject();
            int flags = in.readInt();
            this.regex = Pattern.compile(p, flags);
        }
        this.matchTextFresh = in.readBoolean();
    }

    public static void main(String[] args) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(args[0]));
            String line = in.readLine();
            while (line != null) {
                CharSequenceLexer csl = new CharSequenceLexer((CharSequence)line, LEX_NONWHITESPACE_CLASSES);
                while (csl.hasNext()) {
                    System.out.println(csl.next());
                }
                line = in.readLine();
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

