/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify;

import cc.mallet.classify.Boostable;
import cc.mallet.classify.ClassifierTrainer;
import cc.mallet.classify.MaxEnt;
import cc.mallet.classify.MaxEntOptimizableByLabelLikelihood;
import cc.mallet.optimize.ConjugateGradient;
import cc.mallet.optimize.LimitedMemoryBFGS;
import cc.mallet.optimize.Optimizable;
import cc.mallet.optimize.Optimizer;
import cc.mallet.types.Alphabet;
import cc.mallet.types.InstanceList;
import cc.mallet.util.MalletLogger;
import cc.mallet.util.MalletProgressMessageLogger;
import java.io.Serializable;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxEntTrainer
extends ClassifierTrainer<MaxEnt>
implements ClassifierTrainer.ByOptimization<MaxEnt>,
Boostable,
Serializable {
    private static Logger logger = MalletLogger.getLogger(MaxEntTrainer.class.getName());
    private static Logger progressLogger = MalletProgressMessageLogger.getLogger(MaxEntTrainer.class.getName() + "-pl");
    int numIterations = Integer.MAX_VALUE;
    public static final String EXP_GAIN = "exp";
    public static final String GRADIENT_GAIN = "grad";
    public static final String INFORMATION_GAIN = "info";
    static final double DEFAULT_GAUSSIAN_PRIOR_VARIANCE = 0.1;
    static final Class DEFAULT_MAXIMIZER_CLASS = LimitedMemoryBFGS.class;
    double gaussianPriorVariance = 0.1;
    Class maximizerClass = DEFAULT_MAXIMIZER_CLASS;
    InstanceList trainingSet = null;
    MaxEnt initialClassifier;
    MaxEntOptimizableByLabelLikelihood ome = null;
    Optimizer opt = null;

    public MaxEntTrainer() {
    }

    public MaxEntTrainer(MaxEnt theClassifierToTrain) {
        this.initialClassifier = theClassifierToTrain;
    }

    public MaxEntTrainer(double gaussianPriorVariance) {
        this.gaussianPriorVariance = gaussianPriorVariance;
    }

    @Override
    public MaxEnt getClassifier() {
        if (this.ome != null) {
            return this.ome.getClassifier();
        }
        return this.initialClassifier;
    }

    public void setClassifier(MaxEnt theClassifierToTrain) {
        assert (this.trainingSet == null || Alphabet.alphabetsMatch(theClassifierToTrain, this.trainingSet));
        if (this.initialClassifier != theClassifierToTrain) {
            this.initialClassifier = theClassifierToTrain;
            this.ome = null;
            this.opt = null;
        }
    }

    public Optimizable getOptimizable() {
        return this.ome;
    }

    public MaxEntOptimizableByLabelLikelihood getOptimizable(InstanceList trainingSet) {
        return this.getOptimizable(trainingSet, this.getClassifier());
    }

    public MaxEntOptimizableByLabelLikelihood getOptimizable(InstanceList trainingSet, MaxEnt initialClassifier) {
        if (trainingSet != this.trainingSet || this.initialClassifier != initialClassifier) {
            this.trainingSet = trainingSet;
            this.initialClassifier = initialClassifier;
            if (this.ome == null || this.ome.trainingList != trainingSet) {
                this.ome = new MaxEntOptimizableByLabelLikelihood(trainingSet, initialClassifier);
                this.ome.setGaussianPriorVariance(this.gaussianPriorVariance);
                this.opt = null;
            }
        }
        return this.ome;
    }

    @Override
    public Optimizer getOptimizer() {
        if (this.opt == null && this.ome != null) {
            this.opt = new ConjugateGradient(this.ome);
        }
        return this.opt;
    }

    public Optimizer getOptimizer(InstanceList trainingSet) {
        if (trainingSet != this.trainingSet || this.ome == null) {
            this.getOptimizable(trainingSet);
            this.opt = null;
        }
        if (this.opt == null) {
            this.opt = new LimitedMemoryBFGS(this.ome);
        }
        return this.opt;
    }

    public MaxEntTrainer setNumIterations(int i) {
        this.numIterations = i;
        return this;
    }

    @Override
    public int getIteration() {
        if (this.ome == null) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    public MaxEntTrainer setGaussianPriorVariance(double gaussianPriorVariance) {
        this.gaussianPriorVariance = gaussianPriorVariance;
        return this;
    }

    @Override
    public MaxEnt train(InstanceList trainingSet) {
        return this.train(trainingSet, this.numIterations);
    }

    @Override
    public MaxEnt train(InstanceList trainingSet, int numIterations) {
        logger.fine("trainingSet.size() = " + trainingSet.size());
        this.getOptimizer(trainingSet);
        for (int i = 0; i < numIterations; ++i) {
            boolean converged;
            try {
                converged = this.opt.optimize(1);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                logger.info("Catching exception; saying converged.");
                converged = true;
            }
            if (converged) break;
        }
        if (numIterations == Integer.MAX_VALUE) {
            this.opt = null;
            this.getOptimizer();
            try {
                this.opt.optimize();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                logger.info("Catching exception; saying converged.");
            }
        }
        progressLogger.info("\n");
        return this.ome.getClassifier();
    }

    public String toString() {
        return "MaxEntTrainer,numIterations=" + this.numIterations + ",gaussianPriorVariance=" + this.gaussianPriorVariance;
    }
}

