/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;

public class PropertyList
implements Serializable {
    protected PropertyList next;
    protected String key;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public static PropertyList add(String key, Object value, PropertyList rest) {
        assert (key != null);
        return new ObjectProperty(key, value, rest);
    }

    public static PropertyList add(String key, String value, PropertyList rest) {
        assert (key != null);
        return new ObjectProperty(key, value, rest);
    }

    public static PropertyList add(String key, double value, PropertyList rest) {
        assert (key != null);
        return new NumericProperty(key, value, rest);
    }

    public static PropertyList remove(String key, PropertyList rest) {
        assert (key != null);
        return new ObjectProperty(key, null, rest);
    }

    public Object lookupObject(String key) {
        if (this.key.equals(key)) {
            if (this instanceof ObjectProperty) {
                return ((ObjectProperty)this).value;
            }
            if (this instanceof NumericProperty) {
                return new Double(((NumericProperty)this).value);
            }
            throw new IllegalStateException("Unrecognitized PropertyList entry.");
        }
        if (this.next == null) {
            return null;
        }
        return this.next.lookupObject(key);
    }

    public double lookupNumber(String key) {
        if (this.key.equals(key)) {
            if (this instanceof NumericProperty) {
                return ((NumericProperty)this).value;
            }
            if (this instanceof ObjectProperty) {
                Object obj = ((ObjectProperty)this).value;
                if (obj == null) {
                    return 0.0;
                }
                if (obj instanceof Double) {
                    return (Double)obj;
                }
                if (obj instanceof Integer) {
                    return ((Double)obj).intValue();
                }
                if (obj instanceof Float) {
                    return ((Double)obj).floatValue();
                }
                if (obj instanceof Short) {
                    return ((Double)obj).shortValue();
                }
                if (obj instanceof Long) {
                    return ((Double)obj).longValue();
                }
                return 0.0;
            }
            throw new IllegalStateException("Unrecognitized PropertyList entry.");
        }
        if (this.next == null) {
            return 0.0;
        }
        return this.next.lookupNumber(key);
    }

    public boolean hasProperty(String key) {
        if (this.key.equals(key)) {
            return !(this instanceof ObjectProperty) || ((ObjectProperty)this).value != null;
        }
        if (this.next == null) {
            return false;
        }
        return this.next.hasProperty(key);
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public static PropertyList sumDuplicateKeyValues(PropertyList pl) {
        if (!(pl instanceof NumericProperty)) {
            throw new IllegalArgumentException("PropertyList must be Numeric to sum values");
        }
        HashMap<String, Double> key2value = new HashMap<String, Double>();
        Iterator iter = pl.numericIterator();
        while (iter.hasNext()) {
            iter.nextProperty();
            String key = iter.getKey();
            double val = iter.getNumericValue();
            Double storedValue = (Double)key2value.get(key);
            if (storedValue == null) {
                key2value.put(key, new Double(val));
                continue;
            }
            key2value.put(key, new Double(storedValue + val));
        }
        PropertyList ret = null;
        for (String key : key2value.keySet()) {
            double val = (Double)key2value.get(key);
            ret = PropertyList.add(key, val, ret);
        }
        return ret;
    }

    public Iterator numericIterator() {
        return new NumericIterator(this);
    }

    public Iterator objectIterator() {
        return new ObjectIterator(this);
    }

    protected PropertyList() {
        throw new IllegalArgumentException("Zero args constructor not allowed.");
    }

    protected PropertyList(String key, PropertyList rest) {
        this.key = key;
        this.next = rest;
    }

    public void print() {
        if (this instanceof NumericProperty) {
            System.out.println(this.key.toString() + "=" + ((NumericProperty)this).value);
        } else if (this instanceof ObjectProperty) {
            System.out.println(this.key.toString() + "=" + ((ObjectProperty)this).value);
        } else {
            throw new IllegalArgumentException("Unrecognized PropertyList type");
        }
        if (this.next != null) {
            this.next.print();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.next);
        out.writeObject(this.key);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.next = (PropertyList)in.readObject();
        this.key = (String)in.readObject();
    }

    public int size() {
        PropertyList pl = this;
        int size = 1;
        while (pl.next != null) {
            pl = pl.next;
            ++size;
        }
        return size;
    }

    public PropertyList last() {
        if (this.next == null) {
            return this;
        }
        return this.next.last();
    }

    public PropertyList append(PropertyList nextPl) throws UnsupportedOperationException {
        if (this.next != null) {
            throw new UnsupportedOperationException("PropertyList.java: Cannot append to middle of a list\n");
        }
        this.next = nextPl;
        return this.last();
    }

    public class ObjectIterator
    extends Iterator
    implements Serializable {
        public ObjectIterator(PropertyList pl) {
            super(pl);
            this.returnNumeric = false;
        }
    }

    public class NumericIterator
    extends Iterator
    implements Serializable {
        public NumericIterator(PropertyList pl) {
            super(pl);
            this.returnObject = false;
        }
    }

    public class Iterator
    implements java.util.Iterator,
    Serializable {
        PropertyList property;
        PropertyList nextProperty;
        HashSet deletedKeys = null;
        boolean nextCalled = false;
        boolean returnNumeric = true;
        boolean returnObject = true;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;

        public Iterator(PropertyList pl) {
            this.property = this.findReturnablePropertyAtOrAfter(pl);
            this.nextProperty = this.property == null ? null : this.findReturnablePropertyAtOrAfter(this.property.next);
        }

        private PropertyList findReturnablePropertyAtOrAfter(PropertyList property) {
            while (property != null) {
                if (property instanceof NumericProperty && this.returnNumeric) {
                    if (((NumericProperty)property).value != 0.0) break;
                    if (this.deletedKeys == null) {
                        this.deletedKeys = new HashSet();
                    }
                    this.deletedKeys.add(property.key);
                    property = property.next;
                    continue;
                }
                if (property instanceof ObjectProperty && this.returnObject) {
                    if (((ObjectProperty)property).value != null) break;
                    if (this.deletedKeys == null) {
                        this.deletedKeys = new HashSet();
                    }
                    this.deletedKeys.add(property.key);
                    property = property.next;
                    continue;
                }
                throw new IllegalStateException("Unrecognized property type " + property.getClass().getName());
            }
            return property;
        }

        public boolean hasNext() {
            return this.nextCalled && this.nextProperty != null || !this.nextCalled && this.property != null;
        }

        public boolean isNumeric() {
            return this.property instanceof NumericProperty;
        }

        public double getNumericValue() {
            return ((NumericProperty)this.property).value;
        }

        public Object getObjectValue() {
            return ((ObjectProperty)this.property).value;
        }

        public String getKey() {
            return this.property.key;
        }

        public PropertyList nextProperty() {
            if (this.nextCalled) {
                this.property = this.nextProperty;
                this.nextProperty = this.findReturnablePropertyAtOrAfter(this.property.next);
            } else {
                this.nextCalled = true;
            }
            return this.property;
        }

        public Object next() {
            return this.nextProperty();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(0);
            out.writeObject(this.property);
            out.writeObject(this.nextProperty);
            out.writeObject(this.deletedKeys);
            out.writeBoolean(this.nextCalled);
            out.writeBoolean(this.returnNumeric);
            out.writeBoolean(this.returnObject);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            this.property = (PropertyList)in.readObject();
            this.nextProperty = (PropertyList)in.readObject();
            this.deletedKeys = (HashSet)in.readObject();
            this.nextCalled = in.readBoolean();
            this.returnNumeric = in.readBoolean();
            this.returnObject = in.readBoolean();
        }
    }

    private static class ObjectProperty
    extends PropertyList {
        protected Object value;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;

        public ObjectProperty(String key, Object value, PropertyList rest) {
            super(key, rest);
            this.value = value;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(0);
            out.writeObject(this.value);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            this.value = in.readObject();
        }
    }

    private static class NumericProperty
    extends PropertyList
    implements Serializable {
        protected double value;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;

        public NumericProperty(String key, double value, PropertyList rest) {
            super(key, rest);
            this.value = value;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(0);
            out.writeDouble(this.value);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            this.value = in.readDouble();
        }
    }
}

