/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Exec
extends Task {
    private String os;
    private String out;
    private File dir;
    private String command;
    protected PrintWriter fos = null;
    private boolean failOnError = false;
    private static final int BUFFER_SIZE = 512;

    public void execute() throws BuildException {
        this.run(this.command);
    }

    protected int run(String string) throws BuildException {
        Object object;
        Object object2;
        int n = -1;
        String string2 = System.getProperty("os.name");
        this.log("Myos = " + string2, 3);
        if (this.os != null && this.os.indexOf(string2) < 0) {
            this.log("Not found in " + this.os, 3);
            return 0;
        }
        if (this.dir == null) {
            this.dir = this.project.getBaseDir();
        }
        if (string2.toLowerCase().indexOf("windows") >= 0) {
            if (!this.dir.equals(this.project.resolveFile("."))) {
                if (string2.toLowerCase().indexOf("nt") >= 0) {
                    string = "cmd /c cd " + this.dir + " && " + string;
                } else {
                    object2 = this.project.getProperty("ant.home");
                    if (object2 == null) {
                        throw new BuildException("Property 'ant.home' not found", this.location);
                    }
                    object = this.project.resolveFile((String)object2 + "/bin/antRun.bat").toString();
                    string = (String)object + " " + this.dir + " " + string;
                }
            }
        } else {
            object2 = this.project.getProperty("ant.home");
            if (object2 == null) {
                throw new BuildException("Property 'ant.home' not found", this.location);
            }
            object = this.project.resolveFile((String)object2 + "/bin/antRun").toString();
            string = (String)object + " " + this.dir + " " + string;
        }
        try {
            this.log(string, 3);
            object2 = Runtime.getRuntime().exec(string);
            if (this.out != null) {
                this.fos = new PrintWriter(new FileWriter(this.out));
                this.log("Output redirected to " + this.out, 3);
            }
            object = new StreamPumper(((Process)object2).getInputStream(), 2, this);
            StreamPumper streamPumper = new StreamPumper(((Process)object2).getErrorStream(), 1, this);
            ((Thread)object).start();
            streamPumper.start();
            ((Process)object2).waitFor();
            ((Thread)object).join();
            streamPumper.join();
            ((Process)object2).destroy();
            this.logFlush();
            n = ((Process)object2).exitValue();
            if (n != 0) {
                if (this.failOnError) {
                    throw new BuildException("Exec returned: " + n, this.location);
                }
                this.log("Result: " + n, 0);
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Error exec: " + string, iOException, this.location);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return n;
    }

    public void setDir(String string) {
        this.dir = this.project.resolveFile(string);
    }

    public void setOs(String string) {
        this.os = string;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public void setOutput(String string) {
        this.out = string;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    protected void outputLog(String string, int n) {
        if (this.fos == null) {
            this.log(string, n);
        } else {
            this.fos.println(string);
        }
    }

    protected void logFlush() {
        if (this.fos != null) {
            this.fos.close();
        }
    }

    class StreamPumper
    extends Thread {
        private BufferedReader din;
        private int messageLevel;
        private boolean endOfStream = false;
        private int SLEEP_TIME = 5;
        private Exec parent;

        public StreamPumper(InputStream inputStream, int n, Exec exec2) {
            this.din = new BufferedReader(new InputStreamReader(inputStream));
            this.messageLevel = n;
            this.parent = exec2;
        }

        public void pumpStream() throws IOException {
            byte[] byArray = new byte[512];
            if (!this.endOfStream) {
                String string = this.din.readLine();
                if (string != null) {
                    Exec.this.outputLog(string, this.messageLevel);
                } else {
                    this.endOfStream = true;
                }
            }
        }

        public void run() {
            try {
                try {
                    while (!this.endOfStream) {
                        this.pumpStream();
                        Thread.sleep(this.SLEEP_TIME);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.din.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

