/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.dex.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class HashSetMap
implements Serializable {
    TreeSet values;
    HashMap map;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public HashSetMap(int size) {
        this.map = new HashMap(size);
        this.values = new TreeSet();
    }

    public HashSetMap() {
        this(10);
    }

    public Object put(Object key, Object value) {
        Object ret = this.map.put(key, value);
        this.values.add(value);
        return ret;
    }

    public void putAll(Map m) {
        this.map.putAll(m);
        Iterator iter = m.values().iterator();
        while (iter.hasNext()) {
            this.values.add(iter.next());
        }
    }

    public Collection values() {
        return this.values;
    }

    public Object remove(Object key) {
        Object v = this.map.remove(key);
        this.values.remove(v);
        return v;
    }

    public void clear() {
        this.map.clear();
        this.values = new TreeSet();
    }

    public boolean containsKey(Object k) {
        return this.map.containsKey(k);
    }

    public boolean containsValue(Object v) {
        return this.map.containsValue(v);
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public Object get(Object k) {
        return this.map.get(k);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public Object clone() {
        HashSetMap ret = new HashSetMap();
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            Object k = iter.next();
            ret.put(k, this.get(k));
        }
        return ret;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.map);
        out.writeObject(this.values);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.map = (HashMap)in.readObject();
        this.values = (TreeSet)in.readObject();
    }
}

