/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.dex.web;

import edu.umass.cs.dex.DexRuntimeException;
import edu.umass.cs.dex.types.CountedString;
import edu.umass.cs.dex.types.People;
import edu.umass.cs.dex.types.Person;
import edu.umass.cs.dex.web.Query;
import edu.umass.cs.dex.web.WebThread;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HomePageFinder {
    private static Logger logger = MalletLogger.getLogger(HomePageFinder.class.getName());
    public static final int MIN_NUM_OCCURRENCES = 0;
    File outputDir;
    String userName;
    HashSet stopWords;
    int maxUrls;
    private int timeout;

    public HomePageFinder(File outputDir, String userName, HashSet stopWords, int maxUrls, int timeout) {
        this.outputDir = outputDir;
        this.userName = userName;
        this.stopWords = stopWords;
        this.maxUrls = maxUrls;
        this.timeout = timeout;
    }

    public void findHomePagesFor(People people, File peopleFile, boolean isWideSearch) {
        Vector<WebThread> threads = new Vector<WebThread>();
        Iterator piter = people.iterator();
        while (piter.hasNext()) {
            Person person = (Person)piter.next();
            if (person.processedForWebPages || person.findLogin(this.userName)) continue;
            Query q = new Query(0);
            Vector queries = q.buildQueries(person, isWideSearch);
            if (queries.size() == 0) {
                if (!logger.isLoggable(Level.FINE)) continue;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw, true);
                pw.print("No queries generated for ");
                person.printPersonalInfo(pw);
                logger.fine(sw.toString());
                continue;
            }
            String destDirName = HomePageFinder.generateOutDirName(this.outputDir.toString(), person);
            this.makeDir(destDirName);
            WebThread thread = new WebThread(queries, destDirName, person, this.stopWords, this.maxUrls, people, peopleFile);
            threads.addElement(thread);
            logger.fine("Active count: " + Thread.activeCount());
            logger.fine(thread.getName() + " added; Threads size: " + threads.size());
            logger.fine("Thread " + thread.getName() + " is about to start");
            thread.start();
            person.processedForWebPages = true;
        }
        this.waitForAllThreadsDead(threads);
        this.checkForExceptions(threads);
    }

    private void checkForExceptions(List threads) {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>(threads.size());
        for (int i = 0; i < threads.size(); ++i) {
            WebThread wt = (WebThread)threads.get(i);
            if (wt.getException() == null) continue;
            exceptions.add(wt.getException());
        }
        if (exceptions.isEmpty()) {
            return;
        }
        this.logExceptions(exceptions);
        Throwable e = (Throwable)exceptions.get(0);
        throw (RuntimeException)(e instanceof RuntimeException ? e : new DexRuntimeException("Exception thrown from DEX WebThread", e));
    }

    private void logExceptions(List exceptions) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Exception{s} thrown from DEX WebThread{s}:");
        for (int i = 0; i < exceptions.size(); ++i) {
            ((Exception)exceptions.get(i)).printStackTrace(pw);
            if (i + 1 >= exceptions.size()) continue;
            pw.println();
            pw.println("--------------------------------------");
        }
        pw.flush();
        logger.warning(sw.toString());
    }

    private void waitForAllThreadsDead(Vector threads) {
        for (int i = 0; i < threads.size(); ++i) {
            try {
                WebThread thread = (WebThread)threads.elementAt(i);
                logger.fine(thread.getName() + ") Wait for thread to finish");
                thread.join(this.timeout * 1000);
                if (thread.isAlive()) {
                    logger.warning(thread.getName() + ") Thread - timeout reached - thread will be interrupted");
                    this.interruptAllThreads(threads);
                    throw new DexRuntimeException("Timeout waiting for thread to complete. Timeout set at " + this.timeout + " seconds.");
                }
                logger.fine(thread.getName() + ") Thread finished");
                continue;
            }
            catch (InterruptedException err) {
                logger.warning("Problem with interruptions");
                throw new DexRuntimeException("Interrupt received while waiting for threads to complete", err);
            }
        }
    }

    private void interruptAllThreads(Vector threads) {
        for (int i = 0; i < threads.size(); ++i) {
            WebThread thread = (WebThread)threads.elementAt(i);
            if (!thread.isAlive()) continue;
            thread.interrupt();
            logger.fine(thread.getName() + ") Thread has been interrupted");
        }
    }

    private void makeDir(String dir) {
        File outDir = new File(dir);
        try {
            if (!outDir.exists()) {
                outDir.mkdir();
            }
        }
        catch (SecurityException e) {
            logger.warning("No permission to make directory " + dir);
        }
    }

    public static String generateOutDirName(String outDir, Person person) {
        return outDir + File.separator + ((CountedString)person.names.elementAt((int)0)).str;
    }
}

