/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring.expt;

import com.wcohen.secondstring.DistanceFactory;
import com.wcohen.secondstring.PrintfFormat;
import com.wcohen.secondstring.StringDistance;
import com.wcohen.secondstring.expt.Blocker;
import com.wcohen.secondstring.expt.MatchData;
import com.wcohen.secondstring.expt.NullBlocker;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;

public class MatchExpt
implements Serializable {
    public static final String BLOCKER_PACKAGE = "com.wcohen.secondstring.expt.";
    public static final String DISTANCE_PACKAGE = "com.wcohen.secondstring.";
    private static final long serialVersionUID = 1L;
    private static int CURRENT_SERIALIZED_VERSION_NUMBER = 1;
    private transient Blocker.Pair[] pairs;
    private int numCorrectPairs;
    private double preparationTime;
    private double blockingTime;
    private double matchingTime;
    private double sortingTime;
    private static double[] elevenPoints = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};

    public MatchExpt(MatchData data, StringDistance dist, Blocker blocker) {
        this.setUpExperiment(data, dist, blocker);
    }

    public MatchExpt(MatchData data, StringDistance dist) {
        this(data, dist, new NullBlocker());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.pairs.length);
        for (int i = 0; i < this.pairs.length; ++i) {
            if (!this.correctPair(i)) continue;
            out.writeInt(i);
            out.writeObject(this.pairs[i]);
        }
        out.writeInt(-1);
    }

    private void readObject(ObjectInputStream out) throws IOException, ClassNotFoundException {
        out.defaultReadObject();
        int n = out.readInt();
        this.pairs = new Blocker.Pair[n];
        int nextIndex = out.readInt();
        while (nextIndex >= 0) {
            this.pairs[nextIndex] = (Blocker.Pair)out.readObject();
            nextIndex = out.readInt();
        }
    }

    private void setUpExperiment(MatchData data, StringDistance dist, Blocker blocker) {
        System.out.println("setting up expt: " + dist + " " + blocker + " file: " + data.getFilename());
        long startTime = System.currentTimeMillis();
        data.prepare(dist);
        this.preparationTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        startTime = System.currentTimeMillis();
        blocker.block(data);
        this.blockingTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        this.numCorrectPairs = blocker.numCorrectPairs();
        this.pairs = new Blocker.Pair[blocker.size()];
        startTime = System.currentTimeMillis();
        System.out.println("Pairs: " + this.pairs.length + " Correct: " + blocker.numCorrectPairs());
        for (int i = 0; i < blocker.size(); ++i) {
            this.pairs[i] = blocker.getPair(i);
            this.pairs[i].setDistance(dist.score(this.pairs[i].getA().getText(), this.pairs[i].getB().getText()));
            if (i <= 0 || i % 100000 != 0) continue;
            System.out.println("First " + i + " distances in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " sec");
        }
        this.matchingTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        startTime = System.currentTimeMillis();
        Arrays.sort(this.pairs);
        this.sortingTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        System.out.println("Matching time: " + this.matchingTime);
    }

    public Double time() {
        return new Double(this.preparationTime + this.blockingTime + this.matchingTime + this.sortingTime);
    }

    public Double pairsPerSecond() {
        return new Double((double)this.pairs.length / (this.preparationTime + this.blockingTime + this.matchingTime + this.sortingTime));
    }

    public Double averagePrecision() {
        double n = 0.0;
        double sumPrecision = 0.0;
        for (int i = 0; i < this.pairs.length; ++i) {
            if (!this.correctPair(i)) continue;
            double precisionAtRankI = (n += 1.0) / ((double)i + 1.0);
            sumPrecision += precisionAtRankI;
        }
        return new Double(sumPrecision / (double)this.numCorrectPairs);
    }

    public Double maxF1() {
        double maxF1 = -1.7976931348623157E308;
        double n = 0.0;
        for (int i = 0; i < this.pairs.length; ++i) {
            if (!this.correctPair(i)) continue;
            double precisionAtRankI = (n += 1.0) / ((double)i + 1.0);
            double recallAtRankI = n / (double)this.numCorrectPairs;
            if (!(precisionAtRankI > 0.0) || !(recallAtRankI > 0.0)) continue;
            double f1 = 2.0 * (precisionAtRankI * recallAtRankI) / (precisionAtRankI + recallAtRankI);
            maxF1 = Math.max(f1, maxF1);
        }
        return new Double(maxF1);
    }

    public Double blockerRecall() {
        double n = 0.0;
        for (int i = 0; i < this.pairs.length; ++i) {
            if (!this.correctPair(i)) continue;
            n += 1.0;
        }
        return new Double(n / (double)this.numCorrectPairs);
    }

    public static double[] interpolated11PointRecallLevels() {
        return elevenPoints;
    }

    public double[] interpolated11PointPrecision() {
        double[] interpolatedPrecision = new double[11];
        int numCorrectAtRankI = 0;
        for (int i = 0; i < this.pairs.length; ++i) {
            if (this.correctPair(i)) {
                ++numCorrectAtRankI;
            }
            double recall = (double)numCorrectAtRankI / (double)this.numCorrectPairs;
            double precision = (double)numCorrectAtRankI / ((double)i + 1.0);
            for (int j = 0; j < elevenPoints.length; ++j) {
                if (!(recall >= elevenPoints[j])) continue;
                interpolatedPrecision[j] = Math.max(interpolatedPrecision[j], precision);
            }
        }
        return interpolatedPrecision;
    }

    public void graphPrecisionRecall(PrintStream out) throws IOException {
        int i;
        double[] interpolatedPrecision = new double[this.pairs.length];
        double n = this.numCorrectPairs;
        double maxPrecision = n / (double)this.pairs.length;
        for (i = this.pairs.length - 1; i >= 0; --i) {
            if (!this.correctPair(i)) continue;
            interpolatedPrecision[i] = maxPrecision;
            maxPrecision = Math.max(maxPrecision, (n -= 1.0) / (double)(i + 1));
        }
        n = 0.0;
        for (i = 0; i < this.pairs.length; ++i) {
            if (!this.correctPair(i)) continue;
            double recallAtRankI = (n += 1.0) / (double)this.numCorrectPairs;
            out.println(recallAtRankI + "\t" + interpolatedPrecision[i]);
        }
    }

    public void displayResults(boolean showMismatches, PrintStream out) throws IOException {
        PrintfFormat fmt = new PrintfFormat("%s %3d %7.2f | %30s | %30s\n");
        for (int i = 0; i < this.pairs.length; ++i) {
            String bText;
            if (this.pairs[i] == null) continue;
            String label = this.pairs[i].getA().getId().equals(this.pairs[i].getB().getId()) ? "+" : "-";
            String aText = this.pairs[i].getA() == null ? "***" : this.pairs[i].getA().getText().unwrap();
            String string = bText = this.pairs[i].getB() == null ? "***" : this.pairs[i].getB().getText().unwrap();
            if (!showMismatches && !"+".equals(label)) continue;
            out.print(fmt.sprintf(new Object[]{label, new Integer(i + 1), new Double(this.pairs[i].getDistance()), aText, bText}));
        }
    }

    private boolean correctPair(int i) {
        return this.pairs[i] != null && this.pairs[i].isCorrect();
    }

    public static void main(String[] argv) {
        try {
            Blocker blocker = (Blocker)Class.forName(BLOCKER_PACKAGE + argv[0]).newInstance();
            StringDistance dist = DistanceFactory.build(argv[1]);
            MatchData data = new MatchData(argv[2]);
            MatchExpt expt = new MatchExpt(data, dist, blocker);
            int i = 3;
            while (i < argv.length) {
                String c;
                if ((c = argv[i++]).equals("-display")) {
                    expt.displayResults(true, System.out);
                    continue;
                }
                if (c.equals("-shortDisplay")) {
                    expt.displayResults(false, System.out);
                    continue;
                }
                if (c.equals("-graph")) {
                    expt.graphPrecisionRecall(System.out);
                    continue;
                }
                if (c.equals("-summarize")) {
                    System.out.println("maxF1:\t" + expt.maxF1());
                    System.out.println("avgPrec:\t" + expt.averagePrecision());
                    continue;
                }
                throw new RuntimeException("illegal command " + c);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\nusage: <blocker> <distanceClass> <matchDataFile> [commands]\n");
        }
    }
}

