/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.tui;

import cc.mallet.pipe.CharSequence2TokenSequence;
import cc.mallet.pipe.CharSequenceRemoveHTML;
import cc.mallet.pipe.CharSubsequence;
import cc.mallet.pipe.FeatureSequence2AugmentableFeatureVector;
import cc.mallet.pipe.Input2CharSequence;
import cc.mallet.pipe.Noop;
import cc.mallet.pipe.Pipe;
import cc.mallet.pipe.SaveDataInSource;
import cc.mallet.pipe.SerialPipes;
import cc.mallet.pipe.Target2Label;
import cc.mallet.pipe.TokenSequence2FeatureSequence;
import cc.mallet.pipe.TokenSequence2FeatureSequenceWithBigrams;
import cc.mallet.pipe.TokenSequenceLowercase;
import cc.mallet.pipe.TokenSequenceNGrams;
import cc.mallet.pipe.TokenSequenceRemoveNonAlpha;
import cc.mallet.pipe.TokenSequenceRemoveStopwords;
import cc.mallet.pipe.iterator.FileIterator;
import cc.mallet.types.InstanceList;
import cc.mallet.util.CharSequenceLexer;
import cc.mallet.util.CommandOption;
import cc.mallet.util.MalletLogger;
import cc.mallet.util.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;

public class Text2Vectors {
    private static Logger logger = MalletLogger.getLogger(Text2Vectors.class.getName());
    static CommandOption.SpacedStrings classDirs = new CommandOption.SpacedStrings(Text2Vectors.class, "input", "DIR...", true, null, "The directories containing text files to be classified, one directory per class", null);
    static CommandOption.File outputFile = new CommandOption.File(Text2Vectors.class, "output", "FILE", true, new File("text.vectors"), "Write the instance list to this file; Using - indicates stdout.", null);
    static CommandOption.File usePipeFromVectorsFile = new CommandOption.File(Text2Vectors.class, "use-pipe-from", "FILE", true, new File("text.vectors"), "Use the pipe and alphabets from a previously created vectors file. Allows the creation, for example, of a test set of vectors that arecompatible with a previously created set of training vectors", null);
    static CommandOption.Boolean preserveCase = new CommandOption.Boolean(Text2Vectors.class, "preserve-case", "[TRUE|FALSE]", false, false, "If true, do not force all strings to lowercase.", null);
    static CommandOption.Boolean removeStopWords = new CommandOption.Boolean(Text2Vectors.class, "remove-stopwords", "[TRUE|FALSE]", false, false, "If true, remove common \"stop words\" from the text.", null);
    static CommandOption.File extraStopwordsFile = new CommandOption.File(Text2Vectors.class, "extra-stopwords", "FILE", true, null, "Read whitespace-separated words from this file, and add them to the list of words to ignore.", null);
    static CommandOption.Boolean skipHeader = new CommandOption.Boolean(Text2Vectors.class, "skip-header", "[TRUE|FALSE]", false, false, "If true, in each document, remove text occurring before a blank line.  This is useful for removing email or UseNet headers", null);
    static CommandOption.Boolean skipHtml = new CommandOption.Boolean(Text2Vectors.class, "skip-html", "[TRUE|FALSE]", false, false, "If true, remove text occurring inside <...>, as in HTML or SGML.", null);
    static CommandOption.Boolean binaryFeatures = new CommandOption.Boolean(Text2Vectors.class, "binary-features", "[TRUE|FALSE]", false, false, "If true, features will be binary.", null);
    static CommandOption.IntegerArray gramSizes = new CommandOption.IntegerArray(Text2Vectors.class, "gram-sizes", "INTEGER,[INTEGER,...]", true, new int[]{1}, "Include among the features all n-grams of sizes specified.  For example, to get all unigrams and bigrams, use --gram-sizes 1,2.  This option occurs after the removal of stop words, if removed.", null);
    static CommandOption.Boolean keepSequence = new CommandOption.Boolean(Text2Vectors.class, "keep-sequence", "[TRUE|FALSE]", false, false, "If true, final data will be a FeatureSequence rather than a FeatureVector.", null);
    static CommandOption.Boolean keepSequenceBigrams = new CommandOption.Boolean(Text2Vectors.class, "keep-sequence-bigrams", "[TRUE|FALSE]", false, false, "If true, final data will be a FeatureSequenceWithBigrams rather than a FeatureVector.", null);
    static CommandOption.ObjectFromBean stringPipe = new CommandOption.ObjectFromBean(Text2Vectors.class, "string-pipe", "Pipe constructor", true, null, "Java code for the constructor of a Pipe to be run as soon as input becomes a CharSequence", null);
    static CommandOption.ObjectFromBean tokenPipe = new CommandOption.ObjectFromBean(Text2Vectors.class, "token-pipe", "Pipe constructor", true, null, "Java code for the constructor of a Pipe to be run as soon as input becomes a TokenSequence", null);
    static CommandOption.ObjectFromBean fvPipe = new CommandOption.ObjectFromBean(Text2Vectors.class, "fv-pipe", "Pipe constructor", true, null, "Java code for the constructor of a Pipe to be run as soon as input becomes a FeatureVector", null);

    public static void main(String[] args) throws FileNotFoundException, IOException {
        Pipe instancePipe;
        CommandOption.setSummary(Text2Vectors.class, "A tool for creating instance lists of FeatureVectors or FeatureSequences from text documents.\n");
        CommandOption.process(Text2Vectors.class, args);
        if (args.length == 0) {
            CommandOption.getList(Text2Vectors.class).printUsage(false);
            System.exit(-1);
        }
        if (Text2Vectors.classDirs.value.length == 0) {
            System.err.println("You must include --input DIR1 DIR2 ...' in order to specify alist of directories containing the documents for each class.");
            System.exit(-1);
        }
        int commonPrefixIndex = Strings.commonPrefixIndex(Text2Vectors.classDirs.value);
        logger.info("Labels = ");
        File[] directories = new File[Text2Vectors.classDirs.value.length];
        for (int i = 0; i < Text2Vectors.classDirs.value.length; ++i) {
            directories[i] = new File(Text2Vectors.classDirs.value[i]);
            if (commonPrefixIndex < Text2Vectors.classDirs.value.length) {
                logger.info("   " + Text2Vectors.classDirs.value[i].substring(commonPrefixIndex));
                continue;
            }
            logger.info("   " + Text2Vectors.classDirs.value[i]);
        }
        InstanceList previousInstanceList = null;
        if (!usePipeFromVectorsFile.wasInvoked()) {
            instancePipe = new SerialPipes(new Pipe[]{new Target2Label(), new SaveDataInSource(), new Input2CharSequence(), stringPipe.wasInvoked() ? (Pipe)Text2Vectors.stringPipe.value : new Noop(), Text2Vectors.skipHeader.value ? new CharSubsequence(CharSubsequence.SKIP_HEADER) : new Noop(), Text2Vectors.skipHtml.value ? new CharSequenceRemoveHTML() : new Noop(), Text2Vectors.keepSequenceBigrams.value ? new CharSequence2TokenSequence(CharSequenceLexer.LEX_NONWHITESPACE_CLASSES) : new CharSequence2TokenSequence(), tokenPipe.wasInvoked() ? (Pipe)Text2Vectors.tokenPipe.value : new Noop(), Text2Vectors.preserveCase.value ? new Noop() : new TokenSequenceLowercase(), Text2Vectors.keepSequenceBigrams.value ? new TokenSequenceRemoveNonAlpha(true) : new Noop(), Text2Vectors.removeStopWords.value ? new TokenSequenceRemoveStopwords(false, Text2Vectors.keepSequenceBigrams.value).addStopWords(Text2Vectors.extraStopwordsFile.value) : new Noop(), Text2Vectors.gramSizes.value.length != 1 || Text2Vectors.gramSizes.value[0] != 1 ? new TokenSequenceNGrams(Text2Vectors.gramSizes.value) : new Noop(), Text2Vectors.keepSequenceBigrams.value ? new TokenSequence2FeatureSequenceWithBigrams() : new TokenSequence2FeatureSequence(), Text2Vectors.keepSequence.value || Text2Vectors.keepSequenceBigrams.value ? new Noop() : new FeatureSequence2AugmentableFeatureVector(Text2Vectors.binaryFeatures.value), fvPipe.wasInvoked() ? (Pipe)Text2Vectors.fvPipe.value : new Noop()});
        } else {
            previousInstanceList = InstanceList.load(Text2Vectors.usePipeFromVectorsFile.value);
            instancePipe = previousInstanceList.getPipe();
        }
        InstanceList ilist = new InstanceList(instancePipe);
        boolean removeCommonPrefix = true;
        ilist.addThruPipe(new FileIterator(directories, FileIterator.STARTING_DIRECTORIES, removeCommonPrefix));
        ObjectOutputStream oos = Text2Vectors.outputFile.value.toString().equals("-") ? new ObjectOutputStream(System.out) : new ObjectOutputStream(new FileOutputStream(Text2Vectors.outputFile.value));
        oos.writeObject(ilist);
        oos.close();
        if (usePipeFromVectorsFile.wasInvoked()) {
            System.out.println(" output usepipe ilist pipe instance id =" + previousInstanceList.getPipe().getInstanceId());
            oos = new ObjectOutputStream(new FileOutputStream(Text2Vectors.usePipeFromVectorsFile.value));
            oos.writeObject(previousInstanceList);
            oos.close();
        }
    }
}

