/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.inference;

import cc.mallet.grmm.inference.AbstractInferencer;
import cc.mallet.grmm.inference.Sampler;
import cc.mallet.grmm.types.AbstractTableFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SamplingInferencer
extends AbstractInferencer {
    private int N;
    private Sampler sampler;
    transient Assignment samples;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public SamplingInferencer(Sampler sampler, int n) {
        this.sampler = sampler;
        this.N = n;
    }

    public void computeMarginals(FactorGraph mdl) {
        this.samples = this.sampler.sample(mdl, this.N);
    }

    public Factor lookupMarginal(Variable var) {
        return this.lookupMarginal(new HashVarSet(new Variable[]{var}));
    }

    public Factor lookupMarginal(VarSet varSet) {
        Factor mrgl = this.samples.marginalize(varSet);
        AbstractTableFactor tbl = mrgl.asTable();
        tbl.normalize();
        return tbl;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeInt(this.N);
        out.writeObject(this.sampler);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.readInt();
        this.N = in.readInt();
        this.sampler = (Sampler)in.readObject();
    }

    public String toString() {
        return "(SamplingInferencer: " + this.sampler + " )";
    }
}

