/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.learning.extract;

import cc.mallet.extract.BIOTokenizationFilter;
import cc.mallet.extract.DocumentExtraction;
import cc.mallet.extract.Extraction;
import cc.mallet.extract.Extractor;
import cc.mallet.extract.Tokenization;
import cc.mallet.extract.TokenizationFilter;
import cc.mallet.grmm.learning.ACRF;
import cc.mallet.grmm.util.SliceLabelsSequence;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelSequence;
import cc.mallet.types.LabelsSequence;
import cc.mallet.types.Sequence;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACRFExtractor
implements Extractor {
    private ACRF acrf;
    private Pipe tokPipe;
    private Pipe featurePipe;
    private int slice = 0;
    private String backgroundTag = "O";
    private TokenizationFilter filter;

    public ACRFExtractor(ACRF acrf, Pipe tokPipe, Pipe featurePipe) {
        this.acrf = acrf;
        this.tokPipe = tokPipe;
        this.featurePipe = featurePipe;
        this.filter = new BIOTokenizationFilter();
    }

    @Override
    public Extraction extract(Object o) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Extraction extract(Tokenization toks) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Extraction extract(Iterator<Instance> source) {
        Extraction extraction = new Extraction(this, this.getTargetAlphabet());
        InstanceList tokedList = new InstanceList(this.tokPipe);
        tokedList.addThruPipe(source);
        InstanceList pipedList = new InstanceList(this.getFeaturePipe());
        pipedList.addThruPipe(tokedList.iterator());
        Iterator it1 = tokedList.iterator();
        Iterator it2 = pipedList.iterator();
        while (it1.hasNext()) {
            Instance toked = (Instance)it1.next();
            Instance piped = (Instance)it2.next();
            Tokenization tok = (Tokenization)toked.getData();
            String name = piped.getName().toString();
            Sequence target = (Sequence)piped.getTarget();
            LabelsSequence output = this.acrf.getBestLabels(piped);
            LabelSequence ls = SliceLabelsSequence.sliceLabelsSequence(output, this.slice);
            LabelSequence lsTarget = SliceLabelsSequence.sliceLabelsSequence((LabelsSequence)target, this.slice);
            DocumentExtraction docseq = new DocumentExtraction(name, this.getTargetAlphabet(), tok, ls, lsTarget, this.backgroundTag, this.filter);
            extraction.addDocumentExtraction(docseq);
        }
        return extraction;
    }

    public Extraction extract(InstanceList testing) {
        Extraction extraction = new Extraction(this, this.getTargetAlphabet());
        for (int i = 0; i < testing.size(); ++i) {
            Instance instance = (Instance)testing.get(i);
            Tokenization tok = (Tokenization)instance.getProperty("TOKENIZATION");
            if (tok == null) {
                throw new IllegalArgumentException("To use extract(InstanceList), must save the Tokenization!");
            }
            String name = instance.getName().toString();
            Sequence target = (Sequence)instance.getTarget();
            LabelsSequence output = this.acrf.getBestLabels(instance);
            DocumentExtraction docseq = new DocumentExtraction(name, this.getTargetAlphabet(), tok, output, target, this.backgroundTag, this.filter);
            extraction.addDocumentExtraction(docseq);
        }
        return extraction;
    }

    @Override
    public Pipe getFeaturePipe() {
        return this.featurePipe;
    }

    @Override
    public Pipe getTokenizationPipe() {
        return this.tokPipe;
    }

    @Override
    public void setTokenizationPipe(Pipe pipe) {
        this.tokPipe = pipe;
    }

    @Override
    public Alphabet getInputAlphabet() {
        return this.acrf.getInputAlphabet();
    }

    @Override
    public LabelAlphabet getTargetAlphabet() {
        return (LabelAlphabet)this.acrf.getInputPipe().getTargetAlphabet();
    }

    public ACRF getAcrf() {
        return this.acrf;
    }

    public void setSlice(int sl) {
        this.slice = sl;
    }

    public void setTokenizationFilter(TokenizationFilter filter) {
        this.filter = filter;
    }
}

