/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.types.AbstractFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.ParameterizedFactor;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.util.Randoms;

public class BoltzmannPairFactor
extends AbstractFactor
implements ParameterizedFactor {
    private Variable sigma;
    private Variable x1;
    private Variable x2;
    private VarSet xs;

    public BoltzmannPairFactor(Variable x1, Variable x2, Variable sigma) {
        super(new HashVarSet(new Variable[]{sigma, x1, x2}));
        this.sigma = sigma;
        this.x1 = x1;
        this.x2 = x2;
        this.xs = new HashVarSet(new Variable[]{x1, x2});
        if (x1.getNumOutcomes() != 2) {
            throw new IllegalArgumentException("Discrete variable " + x1 + " in BoltzmannUnary must be binary.");
        }
        if (x2.getNumOutcomes() != 2) {
            throw new IllegalArgumentException("Discrete variable " + x2 + " in BoltzmannUnary must be binary.");
        }
        if (!sigma.isContinuous()) {
            throw new IllegalArgumentException("Parameter " + sigma + " in BoltzmannUnary must be continuous.");
        }
    }

    protected Factor extractMaxInternal(VarSet varSet) {
        throw new UnsupportedOperationException();
    }

    protected double lookupValueInternal(int i) {
        throw new UnsupportedOperationException();
    }

    protected Factor marginalizeInternal(VarSet varsToKeep) {
        throw new UnsupportedOperationException();
    }

    public double value(AssignmentIterator it) {
        Assignment assn = it.assignment();
        Factor tbl = this.sliceForSigma(assn);
        return tbl.value(assn);
    }

    private Factor sliceForSigma(Assignment assn) {
        double sig = assn.getDouble(this.sigma);
        double[] vals = new double[]{Math.exp(-sig), 1.0, 1.0, 1.0};
        return new TableFactor(new Variable[]{this.x1, this.x2}, vals);
    }

    public Factor normalize() {
        throw new UnsupportedOperationException();
    }

    public Assignment sample(Randoms r) {
        throw new UnsupportedOperationException();
    }

    public double logValue(AssignmentIterator it) {
        return Math.log(this.value(it));
    }

    public Factor slice(Assignment assn) {
        Factor sigSlice = this.sliceForSigma(assn);
        return sigSlice.slice(assn);
    }

    public String dumpToString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[Pair BM Factor: ");
        buf.append(this.x1);
        buf.append(" ");
        buf.append(this.x2);
        buf.append(" sigma=");
        buf.append(this.sigma);
        buf.append(" ]");
        return buf.toString();
    }

    public double sumGradLog(Factor q, Variable param, Assignment paramAssn) {
        if (param != this.sigma) {
            throw new IllegalArgumentException();
        }
        Factor q_xs = q.marginalize(new Variable[]{this.x1, this.x2});
        Assignment assn = new Assignment(this.xs.toVariableArray(), new int[]{0, 0});
        return -q_xs.value(assn);
    }

    public Factor duplicate() {
        return new BoltzmannPairFactor(this.x1, this.x2, this.sigma);
    }

    public boolean almostEquals(Factor p, double epsilon) {
        return this.equals(p);
    }

    public boolean isNaN() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoltzmannPairFactor that = (BoltzmannPairFactor)o;
        if (this.sigma != null ? !this.sigma.equals(that.sigma) : that.sigma != null) {
            return false;
        }
        if (this.x1 != null ? !this.x1.equals(that.x1) : that.x1 != null) {
            return false;
        }
        return !(this.x2 != null ? !this.x2.equals(that.x2) : that.x2 != null);
    }

    public int hashCode() {
        int result = this.sigma != null ? this.sigma.hashCode() : 0;
        result = 29 * result + (this.x1 != null ? this.x1.hashCode() : 0);
        result = 29 * result + (this.x2 != null ? this.x2.hashCode() : 0);
        return result;
    }
}

