/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelSequence;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Target2BIOFormat
extends Pipe
implements Serializable {
    String backgroundTag;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public Target2BIOFormat() {
        super(null, new LabelAlphabet());
        this.backgroundTag = "O";
    }

    public Target2BIOFormat(String background) {
        super(null, new LabelAlphabet());
        this.backgroundTag = background;
    }

    public Instance pipe(Instance carrier) {
        int[] indices;
        Object target = carrier.getTarget();
        if (target instanceof TokenSequence) {
            Alphabet v = this.getTargetAlphabet();
            TokenSequence ts = (TokenSequence)target;
            indices = new int[ts.size()];
            String previousString = this.backgroundTag;
            for (int i = 0; i < ts.size(); ++i) {
                String s = ((Token)ts.get(i)).getText();
                String tag = s;
                if (!tag.equals(this.backgroundTag)) {
                    tag = tag.equals(previousString) ? "I-" + tag : "B-" + tag;
                }
                indices[i] = v.lookupIndex(tag);
                previousString = s;
            }
        } else {
            throw new IllegalArgumentException("Unrecognized target type.");
        }
        LabelSequence ls = new LabelSequence((LabelAlphabet)this.getTargetAlphabet(), indices);
        carrier.setTarget(ls);
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.backgroundTag);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.backgroundTag = (String)in.readObject();
    }
}

