/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.MalletLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagedInstanceList
extends InstanceList {
    private static Logger logger = MalletLogger.getLogger(PagedInstanceList.class.getName());
    int instancesPerPage;
    File swapDir;
    BitSet inMemory;
    BitSet pageNotInMemory;
    boolean collectGarbage = true;
    VMID id = new VMID();
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public PagedInstanceList(Pipe pipe, int size, int instancesPerPage, File swapDir) {
        super(pipe, size);
        this.inMemory = new BitSet();
        this.pageNotInMemory = new BitSet();
        this.instancesPerPage = instancesPerPage;
        this.swapDir = swapDir;
        try {
            if (!swapDir.exists()) {
                swapDir.mkdir();
            }
        }
        catch (SecurityException e) {
            System.err.println("No permission to make directory " + swapDir);
            System.exit(-1);
        }
    }

    public PagedInstanceList(Pipe pipe, int size) {
        this(pipe, size, -1, new File("."));
    }

    public PagedInstanceList(Pipe pipe) {
        this(pipe, 10);
    }

    public PagedInstanceList() {
        this(notYetSetPipe);
    }

    @Override
    public InstanceList[] split(Random r, double[] proportions) {
        ArrayList<Integer> shuffled = new ArrayList<Integer>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            shuffled.add(new Integer(i));
        }
        Collections.shuffle(shuffled, r);
        return PagedInstanceList.splitInOrder(shuffled, proportions, this);
    }

    @Override
    public InstanceList[] split(double[] proportions) {
        return this.split(new Random(System.currentTimeMillis()), proportions);
    }

    private static InstanceList[] splitInOrder(List<Integer> instanceIndices, double[] proportions, PagedInstanceList cloneMe) {
        int i;
        int i2;
        double[] maxind = new double[proportions.length];
        System.arraycopy(proportions, 0, maxind, 0, proportions.length);
        InstanceList[] ret = new PagedInstanceList[proportions.length];
        ArrayList[] splitIndices = new ArrayList[proportions.length];
        MatrixOps.normalize(maxind);
        for (i2 = 0; i2 < maxind.length; ++i2) {
            ret[i2] = (PagedInstanceList)cloneMe.cloneEmpty();
            splitIndices[i2] = new ArrayList();
            if (i2 <= 0) continue;
            int n = i2;
            maxind[n] = maxind[n] + maxind[i2 - 1];
        }
        for (i2 = 0; i2 < maxind.length; ++i2) {
            maxind[i2] = Math.rint(maxind[i2] * (double)instanceIndices.size());
        }
        int j = 0;
        for (i = 0; i < instanceIndices.size(); ++i) {
            while ((double)i >= maxind[j]) {
                ++j;
            }
            splitIndices[j].add(new Integer(i));
        }
        for (i = 0; i < splitIndices.length; ++i) {
            Collections.sort(splitIndices[i]);
        }
        for (i = 0; i < cloneMe.size(); ++i) {
            Instance tmpi = null;
            try {
                tmpi = cloneMe.get(i);
            }
            catch (OutOfMemoryError e) {
                tmpi = null;
                System.gc();
                logger.warning("Caught " + e + " while splitting InstanceList. Paging out instances in all lists and retrying...");
                cloneMe.swapOutAll();
                for (int x = 0; x < ret.length; ++x) {
                    if (ret[x].size() <= 0) continue;
                    System.out.println("Swapping out ilist " + x);
                    ((PagedInstanceList)ret[x]).swapOutAll();
                }
                System.gc();
                try {
                    tmpi = cloneMe.get(i);
                }
                catch (OutOfMemoryError ee) {
                    logger.warning("Still can't free enough memory to read in instance " + i + " while splitting. Try using smaller value for \"instancesPerPage\".");
                    System.exit(-1);
                }
            }
            tmpi = tmpi.shallowCopy();
            boolean found = false;
            for (int ii = 0; ii < splitIndices.length; ++ii) {
                if (splitIndices[ii].size() == 0) continue;
                int index = (Integer)splitIndices[ii].get(0);
                if (index == i) {
                    logger.info("adding instance " + i + " to split ilist " + ii);
                    found = true;
                    ((PagedInstanceList)ret[ii]).add(tmpi);
                    splitIndices[ii].remove(0);
                }
                if (found) continue;
                throw new IllegalStateException("Error splitting instances.");
            }
        }
        return ret;
    }

    public InstanceList[] splitByModulo(int m) {
        InstanceList[] ret = new PagedInstanceList[]{(PagedInstanceList)this.cloneEmpty(), (PagedInstanceList)this.cloneEmpty()};
        for (int i = 0; i < this.size(); ++i) {
            if (i % m == 0) {
                ((PagedInstanceList)ret[0]).add(this.get(i));
                continue;
            }
            ((PagedInstanceList)ret[1]).add(this.get(i));
        }
        return ret;
    }

    @Override
    public InstanceList sampleWithReplacement(Random r, int numSamples) {
        int i;
        PagedInstanceList ret = (PagedInstanceList)this.cloneEmpty();
        ArrayList<Integer> indices = new ArrayList<Integer>(numSamples);
        for (i = 0; i < numSamples; ++i) {
            indices.add(new Integer(r.nextInt(this.size())));
        }
        Collections.sort(indices);
        for (i = 0; i < indices.size(); ++i) {
            ret.add(this.get((Integer)indices.get(i)));
        }
        return ret;
    }

    @Override
    public InstanceList sampleWithWeights(Random r, double[] weights) {
        if (weights.length != this.size()) {
            throw new IllegalArgumentException("length of weight vector must equal number of instances");
        }
        if (this.size() == 0) {
            return this.cloneEmpty();
        }
        double sumOfWeights = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            if (weights[i] < 0.0) {
                throw new IllegalArgumentException("weight vector must be non-negative");
            }
            sumOfWeights += weights[i];
        }
        if (sumOfWeights <= 0.0) {
            throw new IllegalArgumentException("weights must sum to positive value");
        }
        PagedInstanceList newList = new PagedInstanceList();
        double[] probabilities = new double[this.size()];
        double sumProbs = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            probabilities[i] = sumProbs += r.nextDouble();
        }
        MatrixOps.timesEquals(probabilities, sumOfWeights / sumProbs);
        probabilities[this.size() - 1] = sumOfWeights;
        int a = 0;
        sumProbs = 0.0;
        for (int b = 0; a < this.size() && b < this.size(); ++b) {
            sumProbs += weights[b];
            while (a < this.size() && probabilities[a] <= sumProbs) {
                newList.add(this.get(b));
                newList.setInstanceWeight(a, 1.0);
                ++a;
            }
        }
        return newList;
    }

    private void swapIn(int index) {
        long start = System.currentTimeMillis();
        if (this.instancesPerPage == -1) {
            throw new IllegalStateException("instancesPerPage not set => swapOut not yet called => swapIn cannot be called yet.");
        }
        int bin = index / this.instancesPerPage;
        if (this.pageNotInMemory.get(bin)) {
            logger.info("Swapping in instance " + index + " from page " + bin);
            this.swapOutExcept(index);
            try {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(new File(this.swapDir, this.id + "." + String.valueOf(bin))));
                for (int ii = 0; ii < this.instancesPerPage; ++ii) {
                    Instance inst = (Instance)in.readObject();
                    int newIndex = this.instancesPerPage * bin + ii;
                    inst.unLock();
                    inst.lock();
                    if (this.inMemory.get(newIndex)) {
                        throw new IllegalStateException(newIndex + " already in memory! ");
                    }
                    super.set(newIndex, inst);
                    this.inMemory.set(newIndex);
                    if (newIndex == this.size() - 1) break;
                }
                this.pageNotInMemory.set(bin, false);
            }
            catch (Exception e) {
                System.err.println(e);
                System.exit(-1);
            }
        }
        long end = System.currentTimeMillis();
        logger.info("PagedInstaceList swap-in time (ms) = " + (end - start));
    }

    public void swapOutAll() {
        this.swapOutExcept(this.size());
    }

    private void swapOutExcept(int index) {
        long start = System.currentTimeMillis();
        if (index < 0 || this.inMemory.cardinality() < 1) {
            logger.warning("nothing to swap out to read instance " + index);
            return;
        }
        if (this.instancesPerPage == -1) {
            this.instancesPerPage = Math.max(this.size() / 2, 1);
        }
        int binToKeep = index / this.instancesPerPage;
        int maxBin = (this.size() - 1) / this.instancesPerPage;
        for (int i = 0; i <= maxBin; ++i) {
            if (i == binToKeep || this.pageNotInMemory.get(i)) continue;
            logger.info("\tSwapping out page " + i);
            try {
                int beginIndex = i * this.instancesPerPage;
                int endIndex = Math.min((i + 1) * this.instancesPerPage - 1, this.size() - 1);
                File f = new File(this.swapDir, this.id + "." + String.valueOf(i));
                if (!f.exists()) {
                    try {
                        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(f));
                        for (int bi = beginIndex; bi <= endIndex; ++bi) {
                            Instance inst = this.get(bi);
                            if (inst.getDataAlphabet() != null) {
                                inst.getDataAlphabet().setInstanceId(new VMID());
                            }
                            if (inst.getTargetAlphabet() != null) {
                                inst.getTargetAlphabet().setInstanceId(new VMID());
                            }
                            assert (inst != null) : "null instance while swapping out page from bin " + i;
                            inst.unLock();
                            inst.lock();
                            out.writeObject(inst);
                        }
                        out.close();
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        System.exit(-1);
                    }
                }
                for (int bi = beginIndex; bi <= endIndex; ++bi) {
                    super.set(bi, null);
                    this.inMemory.set(bi, false);
                }
                logger.fine("Swapping out page " + i);
                this.pageNotInMemory.set(i, true);
                continue;
            }
            catch (OutOfMemoryError ee) {
                System.out.println("Ran out of memory while swapping out.");
                System.exit(-1);
            }
        }
        if (this.collectGarbage) {
            System.gc();
        }
        long end = System.currentTimeMillis();
        logger.info("PagedInstanceList swapout time (ms) = " + (end - start));
    }

    @Override
    public Instance get(int index) {
        if (!this.inMemory.get(index)) {
            this.swapIn(index);
        }
        return (Instance)super.get(index);
    }

    @Override
    public Instance set(int index, Instance instance) {
        if (!this.inMemory.get(index)) {
            this.swapIn(index);
        }
        return super.set(index, instance);
    }

    @Override
    public boolean add(Instance instance) {
        boolean ret = super.add(instance);
        this.inMemory.set(this.size() - 1);
        logger.finer("Added instance " + (this.size() - 1) + ". Free memory remaining (bytes): " + Runtime.getRuntime().freeMemory());
        return ret;
    }

    public void setCollectGarbage(boolean b) {
        this.collectGarbage = b;
    }

    public boolean collectGarbage() {
        return this.collectGarbage;
    }

    @Override
    public InstanceList shallowClone() {
        PagedInstanceList ret = (PagedInstanceList)this.cloneEmpty();
        for (int i = 0; i < this.size(); ++i) {
            ret.add(this.get(i));
        }
        return ret;
    }

    @Override
    public InstanceList cloneEmpty() {
        PagedInstanceList ret = (PagedInstanceList)super.cloneEmptyInto(new PagedInstanceList(this.pipe, this.size(), this.instancesPerPage, this.swapDir));
        ret.collectGarbage = this.collectGarbage;
        return ret;
    }

    public static InstanceList load(File file) {
        try {
            ObjectInputStream ois = file.toString().equals("-") ? new ObjectInputStream(System.in) : new ObjectInputStream(new FileInputStream(file));
            PagedInstanceList ilist = (PagedInstanceList)ois.readObject();
            ois.close();
            return ilist;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Couldn't read PagedInstanceList from file " + file);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.id);
        out.writeObject(this.pipe);
        out.writeInt(this.instancesPerPage);
        out.writeObject(this.swapDir);
        out.writeObject(this.inMemory);
        out.writeObject(this.pageNotInMemory);
        out.writeBoolean(this.collectGarbage);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.id = (VMID)in.readObject();
        this.pipe = (Pipe)in.readObject();
        this.instancesPerPage = in.readInt();
        this.swapDir = (File)in.readObject();
        this.inMemory = (BitSet)in.readObject();
        this.pageNotInMemory = (BitSet)in.readObject();
        this.collectGarbage = in.readBoolean();
    }
}

