/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.StringDistance;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class DistanceFactory {
    public static StringDistance build(String classNames) {
        return DistanceFactory.build(0, DistanceFactory.split(classNames));
    }

    public static StringDistance build(String[] classNames) {
        return DistanceFactory.build(0, classNames);
    }

    private static StringDistance build(int lo, String[] classNames) {
        try {
            Class c = DistanceFactory.findClassFor(classNames[lo]);
            if (lo == classNames.length - 1) {
                return (StringDistance)c.newInstance();
            }
            StringDistance innerDist = DistanceFactory.build(lo + 1, classNames);
            Constructor constr = c.getConstructor(StringDistance.class);
            StringDistance result = (StringDistance)constr.newInstance(innerDist);
            String p = DistanceFactory.findParamFor(classNames[lo]);
            if (p != null) {
                String v = DistanceFactory.findParamValueFor(classNames[lo]);
                Double d = new Double(Double.parseDouble(v));
                String setMethodName = "set" + p.substring(0, 1).toUpperCase() + p.substring(1);
                Method m = result.getClass().getMethod(setMethodName, Double.class);
                m.invoke((Object)result, d);
            }
            return result;
        }
        catch (Exception e) {
            StringBuffer buf = new StringBuffer(classNames[0]);
            if (lo == 0) {
                buf.append("<<<");
            }
            for (int i = 1; i < classNames.length; ++i) {
                buf.append("/" + classNames[i]);
                if (lo != i) continue;
                buf.append("<<<");
            }
            throw new IllegalStateException("error building '" + buf + "': " + e);
        }
    }

    private static String findParamFor(String s) {
        int endClassIndex = s.indexOf(91);
        if (endClassIndex < 0) {
            return null;
        }
        int endParamIndex = s.indexOf(61, endClassIndex + 1);
        if (endParamIndex < 0) {
            throw new IllegalStateException("illegal class description '" + s + "'");
        }
        return s.substring(endClassIndex + 1, endParamIndex);
    }

    private static String findParamValueFor(String s) {
        int endParamIndex = s.indexOf(61);
        int endValueIndex = s.indexOf(93, endParamIndex);
        if (endValueIndex < 0) {
            throw new IllegalStateException("illegal class description '" + s + "'");
        }
        return s.substring(endParamIndex + 1, endValueIndex);
    }

    private static Class findClassFor(String s) throws ClassNotFoundException {
        int endClassIndex = s.indexOf(91);
        if (endClassIndex >= 0) {
            s = s.substring(0, endClassIndex);
        }
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            return Class.forName("com.wcohen.secondstring." + s);
        }
    }

    private static String[] split(String s) {
        ArrayList<String> list = new ArrayList<String>();
        int begin = 0;
        int end = s.indexOf(47);
        while (end >= 0) {
            list.add(s.substring(begin, end));
            begin = end + 1;
            end = s.indexOf(47, end + 1);
        }
        list.add(s.substring(begin));
        return list.toArray(new String[list.size()]);
    }

    public static void main(String[] args) {
        try {
            if (args[0].indexOf(47) > 0) {
                System.out.println(DistanceFactory.build(args[0]));
            } else {
                System.out.println(DistanceFactory.build(args));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

