/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.pace;

import weka.classifiers.functions.pace.DoubleVector;
import weka.classifiers.functions.pace.FlexibleDecimalFormat;
import weka.classifiers.functions.pace.IntVector;

public class DiscreteFunction {
    protected DoubleVector points;
    protected DoubleVector values;

    public DiscreteFunction() {
        this(null, null);
    }

    public DiscreteFunction(DoubleVector doubleVector) {
        this(doubleVector, null);
    }

    public DiscreteFunction(DoubleVector doubleVector, DoubleVector doubleVector2) {
        this.points = doubleVector;
        this.values = doubleVector2;
        this.formalize();
    }

    private DiscreteFunction formalize() {
        if (this.points == null) {
            this.points = new DoubleVector();
        }
        if (this.values == null) {
            this.values = new DoubleVector();
        }
        if (this.points.isEmpty()) {
            if (!this.values.isEmpty()) {
                throw new IllegalArgumentException("sizes not match");
            }
        } else {
            int n = this.points.size();
            if (this.values.isEmpty()) {
                this.values = new DoubleVector(n, 1.0 / (double)n);
            } else if (this.values.size() != n) {
                throw new IllegalArgumentException("sizes not match");
            }
        }
        return this;
    }

    public DiscreteFunction normalize() {
        double d;
        if (!this.values.isEmpty() && (d = this.values.sum()) != 0.0 && d != 1.0) {
            this.values.timesEquals(1.0 / d);
        }
        return this;
    }

    public void sort() {
        IntVector intVector = this.points.sortWithIndex();
        this.values = this.values.subvector(intVector);
    }

    public Object clone() {
        DiscreteFunction discreteFunction = new DiscreteFunction();
        discreteFunction.points = (DoubleVector)this.points.clone();
        discreteFunction.values = (DoubleVector)this.values.clone();
        return discreteFunction;
    }

    public DiscreteFunction unique() {
        int n = 0;
        if (this.size() < 2) {
            return this;
        }
        for (int i = 1; i <= this.size() - 1; ++i) {
            if (this.points.get(n) != this.points.get(i)) {
                this.points.set(++n, this.points.get(i));
                this.values.set(n, this.values.get(i));
                continue;
            }
            this.values.set(n, this.values.get(n) + this.values.get(i));
        }
        this.points = this.points.subvector(0, n);
        this.values = this.values.subvector(0, n);
        return this;
    }

    public int size() {
        if (this.points == null) {
            return 0;
        }
        return this.points.size();
    }

    public double getPointValue(int n) {
        return this.points.get(n);
    }

    public double getFunctionValue(int n) {
        return this.values.get(n);
    }

    public void setPointValue(int n, double d) {
        this.points.set(n, d);
    }

    public void setFunctionValue(int n, double d) {
        this.values.set(n, d);
    }

    protected DoubleVector getPointValues() {
        return this.points;
    }

    protected DoubleVector getFunctionValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public DiscreteFunction plus(DiscreteFunction discreteFunction) {
        return ((DiscreteFunction)this.clone()).plusEquals(discreteFunction);
    }

    public DiscreteFunction plusEquals(DiscreteFunction discreteFunction) {
        this.points = this.points.cat(discreteFunction.points);
        this.values = this.values.cat(discreteFunction.values);
        return this;
    }

    public DiscreteFunction timesEquals(double d) {
        this.values.timesEquals(d);
        return this;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        FlexibleDecimalFormat flexibleDecimalFormat = new FlexibleDecimalFormat(5);
        flexibleDecimalFormat.grouping(true);
        FlexibleDecimalFormat flexibleDecimalFormat2 = new FlexibleDecimalFormat(5);
        flexibleDecimalFormat2.grouping(true);
        for (n = 0; n < this.size(); ++n) {
            flexibleDecimalFormat.update(this.points.get(n));
            flexibleDecimalFormat2.update(this.values.get(n));
        }
        stringBuffer.append("\t" + flexibleDecimalFormat.formatString("Points") + "\t" + flexibleDecimalFormat2.formatString("Values") + "\n\n");
        for (n = 0; n <= this.size() - 1; ++n) {
            stringBuffer.append("\t" + flexibleDecimalFormat.format(this.points.get(n)) + "\t" + flexibleDecimalFormat2.format(this.values.get(n)) + "\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[]{2.0, 1.0, 2.0, 3.0, 3.0};
        double[] dArray2 = new double[]{3.0, 2.0, 4.0, 1.0, 3.0};
        DiscreteFunction discreteFunction = new DiscreteFunction(new DoubleVector(dArray), new DoubleVector(dArray2));
        System.out.println(discreteFunction);
        discreteFunction.normalize();
        System.out.println("d (after normalize) = \n" + discreteFunction);
        dArray[1] = 10.0;
        System.out.println("d (after setting [1]) = \n" + discreteFunction);
        discreteFunction.sort();
        System.out.println("d (after sorting) = \n" + discreteFunction);
        discreteFunction.unique();
        System.out.println("d (after unique) = \n" + discreteFunction);
    }
}

