/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.util.Properties;
import java.util.Vector;
import org.python.core.Options;

class CommandLineOptions {
    public String filename = null;
    public boolean jar = false;
    public boolean interactive = true;
    public boolean notice = true;
    private boolean fixInteractive = false;
    public boolean help = false;
    public boolean version = false;
    public String[] argv;
    public Properties properties;
    public String command;
    public Vector warnoptions = new Vector();
    public String encoding;
    public String division;

    public CommandLineOptions() {
        this.properties = new Properties();
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public boolean parse(String[] args) {
        int index;
        for (index = 0; index < args.length && args[index].startsWith("-"); ++index) {
            String arg = args[index];
            if (arg.equals("--help")) {
                this.help = true;
                return false;
            }
            if (arg.equals("--version")) {
                this.version = true;
                return false;
            }
            if (arg.equals("-")) {
                if (!this.fixInteractive) {
                    this.interactive = false;
                }
                this.filename = "-";
                continue;
            }
            if (arg.equals("-i")) {
                this.fixInteractive = true;
                this.interactive = true;
                continue;
            }
            if (arg.equals("-jar")) {
                this.jar = true;
                if (this.fixInteractive) continue;
                this.interactive = false;
                continue;
            }
            if (arg.equals("-v")) {
                ++Options.verbose;
                continue;
            }
            if (arg.equals("-vv")) {
                Options.verbose += 2;
                continue;
            }
            if (arg.equals("-vvv")) {
                Options.verbose += 3;
                continue;
            }
            if (arg.equals("-S")) {
                Options.importSite = false;
                continue;
            }
            if (arg.equals("-c")) {
                this.command = args[++index];
                if (!this.fixInteractive) {
                    this.interactive = false;
                }
                ++index;
                break;
            }
            if (arg.equals("-W")) {
                this.warnoptions.addElement(args[++index]);
                continue;
            }
            if (arg.equals("-E")) {
                this.encoding = args[++index];
                continue;
            }
            if (arg.startsWith("-D")) {
                String key = null;
                String value = null;
                int equals = arg.indexOf("=");
                if (equals == -1) {
                    String arg2 = args[++index];
                    key = arg.substring(2, arg.length());
                    value = arg2;
                } else {
                    key = arg.substring(2, equals);
                    value = arg.substring(equals + 1, arg.length());
                }
                this.setProperty(key, value);
                continue;
            }
            if (arg.startsWith("-Q")) {
                if (arg.length() > 2) {
                    this.division = arg.substring(2);
                    continue;
                }
                this.division = args[++index];
                continue;
            }
            String opt = args[index];
            if (opt.startsWith("--")) {
                opt = opt.substring(2);
            } else if (opt.startsWith("-")) {
                opt = opt.substring(1);
            }
            System.err.println("jython: illegal option -- " + opt);
            return false;
        }
        this.notice = this.interactive;
        if (this.filename == null && index < args.length && this.command == null) {
            this.filename = args[index++];
            if (!this.fixInteractive) {
                this.interactive = false;
            }
            this.notice = false;
        }
        if (this.command != null) {
            this.notice = false;
        }
        int n = args.length - index + 1;
        this.argv = new String[n];
        this.argv[0] = this.filename != null ? this.filename : (this.command != null ? "-c" : "");
        int i = 1;
        while (i < n) {
            this.argv[i] = args[index];
            ++i;
            ++index;
        }
        return true;
    }
}

