/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.dex.types;

import edu.umass.cs.dex.DexRuntimeException;
import edu.umass.cs.dex.types.People;
import edu.umass.cs.dex.types.Person;
import edu.umass.cs.dex.types.WeightedString;
import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.FeatureVector;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public class InformationGain
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(InformationGain.class.getName());
    double overallWeight;
    public HashMap wordWeights = new HashMap();
    public HashMap personWeights = new HashMap();
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public InformationGain(People people, String outDirName) {
        this.fillWeightMaps(people);
        this.calculateInformationGain(people, outDirName);
    }

    public InformationGain(People people) {
        this.fillWeightMaps(people);
        this.calculateInformationGain(people, null);
    }

    public HashMap featureVector2HashMap(FeatureVector fv) {
        HashMap<String, Double> h = new HashMap<String, Double>(fv.numLocations());
        Alphabet alph = fv.getAlphabet();
        for (int i = 0; i < fv.numLocations(); ++i) {
            double value = fv.valueAtLocation(i);
            int index = fv.indexAtLocation(i);
            String word = (String)alph.lookupObject(index);
            h.put(word, new Double(value));
        }
        return h;
    }

    public void updateWordWeights(String word, Double wordCurrentWeight) {
        Double wordWeight = (Double)this.wordWeights.get(word);
        if (wordWeight != null) {
            this.wordWeights.put(word, new Double(wordWeight + wordCurrentWeight));
        } else {
            this.wordWeights.put(word, wordCurrentWeight);
        }
    }

    public void updatePersonWeights(Person person, Double wordCurrentWeight) {
        Double wordWeight = (Double)this.personWeights.get(person);
        if (wordWeight != null) {
            this.personWeights.put(person, new Double(wordWeight + wordCurrentWeight));
        } else {
            this.personWeights.put(person, wordCurrentWeight);
        }
    }

    public void fillWeightMaps(People people) {
        Iterator iter = people.iterator();
        while (iter.hasNext()) {
            Person person = (Person)iter.next();
            HashMap words = this.featureVector2HashMap((FeatureVector)person.keyWords);
            Object[] wordArray = words.keySet().toArray();
            for (int j = 0; j < wordArray.length; ++j) {
                String word = (String)wordArray[j];
                Double wordCurrentWeight = (Double)words.get(word);
                this.updateWordWeights(word, wordCurrentWeight);
                this.updatePersonWeights(person, wordCurrentWeight);
                this.overallWeight += wordCurrentWeight.doubleValue();
            }
        }
    }

    public double calculateInformationGain(PersonWordWeights data) {
        double infoGain = 0.0;
        if (data.w_in_p != 0.0) {
            infoGain = data.w_in_p * Math.log(data.w_in_p * this.overallWeight / (data.w * data.p));
        }
        if (data.w_in_not_p != 0.0) {
            infoGain += data.w_in_not_p * Math.log(data.w_in_not_p * this.overallWeight / (data.w * data.not_p));
        }
        infoGain += data.not_w_in_p * Math.log(data.not_w_in_p * this.overallWeight / (data.not_w * data.p));
        infoGain += data.not_w_in_not_p * Math.log(data.not_w_in_not_p * this.overallWeight / (data.not_w * data.not_p));
        return infoGain /= this.overallWeight;
    }

    public double calculateLogRatio(PersonWordWeights data) {
        double logRatio = 0.0;
        logRatio = data.w_in_p / data.p * Math.log(data.w_in_p * data.not_p / (data.p * data.w_in_not_p));
        return logRatio;
    }

    public void updateSortedWords(ArrayList sortedWords, WeightedString weightedWord) {
        if (sortedWords.size() == 0) {
            sortedWords.add(weightedWord);
            return;
        }
        for (int i = 0; i < sortedWords.size(); ++i) {
            WeightedString currentWeightedWord = (WeightedString)sortedWords.get(i);
            if (!(weightedWord.weight >= currentWeightedWord.weight)) continue;
            sortedWords.add(i, weightedWord);
            return;
        }
        sortedWords.add(weightedWord);
    }

    public void calculateInformationGain(Person person, BufferedWriter out) {
        ArrayList sortedWords = new ArrayList();
        PersonWordWeights data = new PersonWordWeights();
        try {
            data.p = (Double)this.personWeights.get(person);
        }
        catch (NullPointerException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            pw.print("Null pointer in people data: ");
            person.print(pw);
            logger.severe(sw + " : " + e);
            throw new DexRuntimeException(sw.toString(), e);
        }
        data.not_p = this.overallWeight - data.p;
        HashMap words = this.featureVector2HashMap((FeatureVector)person.keyWords);
        Object[] wordArray = words.keySet().toArray();
        for (int j = 0; j < wordArray.length; ++j) {
            String word = (String)wordArray[j];
            data.w_in_p = (Double)words.get(word);
            data.w = (Double)this.wordWeights.get(word);
            data.not_w = this.overallWeight - data.w;
            data.w_in_not_p = data.w - data.w_in_p;
            if (data.w_in_not_p == 0.0) {
                data.w_in_not_p = 1.0;
            }
            data.not_w_in_p = data.p - data.w_in_p;
            data.not_w_in_not_p = data.not_p - data.w_in_not_p;
            double infoGain = this.calculateInformationGain(data);
            WeightedString weightedWord = new WeightedString(word, infoGain);
            this.updateSortedWords(sortedWords, weightedWord);
        }
        if (out != null) {
            this.printInformationGains(person, sortedWords, out);
        }
        person.setTopKeyWordWeights(sortedWords);
    }

    public static void makeDir(File dir) {
        try {
            if (!dir.exists()) {
                dir.mkdir();
            }
        }
        catch (SecurityException e) {
            logger.severe("No permission to make directory " + dir);
        }
    }

    public void calculateInformationGain(People people, String outDirName) {
        try {
            if (outDirName != null) {
                InformationGain.makeDir(new File(outDirName));
            }
            Iterator iter = people.iterator();
            while (iter.hasNext()) {
                Person person = (Person)iter.next();
                if (person.keyWords.numLocations() == 0) continue;
                BufferedWriter out = null;
                if (outDirName != null) {
                    String outFileName = outDirName + File.separator + person.getFirstName() + ".txt";
                    out = new BufferedWriter(new FileWriter(new File(outFileName)));
                    logger.fine("InfoGain for " + person.names.get(0));
                }
                this.calculateInformationGain(person, out);
                if (out == null) continue;
                out.close();
            }
        }
        catch (IOException e) {
            logger.severe("IO problem in outputting keywords: " + e);
        }
    }

    public void printInformationGains(Person person, ArrayList sortedWords, BufferedWriter out) {
        try {
            int MAX_NUM_OF_WORDS = 100;
            for (int i = 0; i < sortedWords.size() && i < MAX_NUM_OF_WORDS; ++i) {
                WeightedString weightedWord = (WeightedString)sortedWords.get(i);
                out.write(weightedWord.str);
                out.newLine();
            }
        }
        catch (IOException e) {
            logger.severe("Problem with writing to infogain file");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeDouble(this.overallWeight);
        out.writeObject(this.wordWeights);
        out.writeObject(this.personWeights);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        double overallWeight = in.readDouble();
        this.wordWeights = (HashMap)in.readObject();
        this.personWeights = (HashMap)in.readObject();
    }

    public class PersonWordWeights {
        double p;
        double not_p;
        double w;
        double not_w;
        double w_in_p;
        double w_in_not_p;
        double not_w_in_p;
        double not_w_in_not_p;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(0);
            out.writeDouble(this.p);
            out.writeDouble(this.not_p);
            out.writeDouble(this.w);
            out.writeDouble(this.not_w);
            out.writeDouble(this.w_in_p);
            out.writeDouble(this.w_in_not_p);
            out.writeDouble(this.not_w_in_p);
            out.writeDouble(this.not_w_in_not_p);
        }

        private void readObject(ObjectInputStream in) throws IOException {
            int version = in.readInt();
            this.p = in.readDouble();
            this.not_p = in.readDouble();
            this.w = in.readDouble();
            this.not_w = in.readDouble();
            this.w_in_p = in.readDouble();
            this.w_in_not_p = in.readDouble();
            this.not_w_in_p = in.readDouble();
            this.not_w_in_not_p = in.readDouble();
        }
    }
}

