/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.dex.types;

import edu.umass.cs.dex.DexRuntimeException;
import edu.umass.cs.dex.types.CountedString;
import edu.umass.cs.dex.types.HashSetMap;
import edu.umass.cs.dex.types.Person;
import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.AugmentableFeatureVector;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class People
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(People.class.getName());
    private HashSetMap id2person;
    private int peopleAdded;
    protected Alphabet alphabet;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public People() {
        this.id2person = new HashSetMap();
        this.alphabet = new Alphabet();
        this.peopleAdded = 0;
    }

    public People(Vector _people) {
        logger.fine("Constructing " + _people.size() + " people");
        this.id2person = new HashSetMap(_people.size());
        this.alphabet = new Alphabet();
        this.peopleAdded = 0;
        for (int i = 0; i < _people.size(); ++i) {
            Person p = (Person)_people.get(i);
            this.addPerson(p);
        }
    }

    public static People readNames(File file) {
        People ret = new People();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                String name = "";
                String domain = "";
                String login = "";
                if (line.matches(".*@.*")) {
                    String[] wds = line.split("\\s+");
                    String email = wds[0];
                    Matcher m = Pattern.compile("\\s*(\\S+)@(\\S+)\\s*").matcher(email);
                    if (m.matches()) {
                        login = m.group(1);
                        domain = m.group(2);
                    }
                    for (int i = 1; i < wds.length; ++i) {
                        name = name + wds[i] + " ";
                    }
                } else {
                    name = line;
                }
                Person p = new Person(name.trim().toLowerCase(), login.trim().toLowerCase(), domain.trim().toLowerCase());
                ret.addPerson(p);
            }
        }
        catch (IOException e) {
            String msg = "Can't read people file: " + file;
            logger.severe(msg + " : " + e);
            throw new DexRuntimeException(msg, e);
        }
        return ret;
    }

    public int size() {
        return this.id2person.values().size();
    }

    public HashSetMap getMap() {
        return this.id2person;
    }

    public Iterator iterator() {
        return this.id2person.values().iterator();
    }

    public Person getPerson(Integer id) {
        return (Person)this.id2person.get(id);
    }

    public Person getPerson(int id) {
        return this.getPerson(new Integer(id));
    }

    public void addPerson(Person person) {
        person = this.consolidateAlphabetFor(person);
        if (!person.alphabet.equals(this.alphabet)) {
            throw new IllegalArgumentException("Alphabets don't match!");
        }
        person.setId(this.peopleAdded++);
        this.id2person.put(new Integer(person.getId()), person);
        Iterator iiter = person.inLinks.iterator();
        while (iiter.hasNext()) {
            Person from = (Person)this.id2person.get((Integer)iiter.next());
            from.addOutLink(person.getId());
        }
        Person[] people = this.id2person.values().toArray(new Person[0]);
        for (int i = 0; i < people.length; ++i) {
            Person p = people[i];
            if (p == null || !p.namesIntersect(person) || p.equals(person)) continue;
            logger.fine("Merging " + p + " AND " + person);
            p.mergeTwoPeople(person);
            int id = person.getId();
            this.changeLinks(p, person.getId(), p.getId());
            this.removePerson(person);
            this.id2person.put(new Integer(id), this.id2person.get(new Integer(p.getId())));
            people = this.id2person.values().toArray(new Person[0]);
            i = 0;
            person = p;
        }
    }

    public void addAll(People otherPeople) {
        logger.fine("Merging " + otherPeople.size() + " people into " + this.size() + " existing people...");
        Iterator iter = otherPeople.iterator();
        while (iter.hasNext()) {
            this.addPerson((Person)iter.next());
        }
    }

    private void changeLinks(Person p, int oldId, int newId) {
        this.changeInLinks(p, oldId, newId);
        this.changeOutLinks(p, oldId, newId);
    }

    private void changeInLinks(Person p, int oldId, int newId) {
        Iterator iter = p.inLinks.iterator();
        while (iter.hasNext()) {
            int index = (Integer)iter.next();
            Person n = this.getPerson(index);
            if (n == null) {
                logger.info("WARNING: Link to " + p + " from index " + index + " is dead since the person at this index no longer exists\n");
                continue;
            }
            n.outLinks.remove(new Integer(oldId));
            n.outLinks.add(new Integer(newId));
        }
    }

    private void changeOutLinks(Person p, int oldId, int newId) {
        Iterator iter = p.outLinks.iterator();
        while (iter.hasNext()) {
            int id = (Integer)iter.next();
            Person n = this.getPerson(id);
            n.inLinks.remove(new Integer(oldId));
            n.inLinks.add(new Integer(newId));
        }
    }

    private Person consolidateAlphabetFor(Person p) {
        if (p.keyWords.singleSize() == 0 && p.contextModel.singleSize() == 0) {
            p.setAlphabet(this.alphabet);
        } else {
            String entry;
            double value;
            int oldIndex;
            int i;
            Alphabet oldAlph = p.alphabet;
            AugmentableFeatureVector newKeyWords = new AugmentableFeatureVector(this.alphabet);
            AugmentableFeatureVector newContextModel = new AugmentableFeatureVector(this.alphabet);
            for (i = 0; i < p.keyWords.numLocations(); ++i) {
                oldIndex = p.keyWords.indexAtLocation(i);
                value = p.keyWords.valueAtLocation(i);
                entry = (String)oldAlph.lookupObject(oldIndex);
                newKeyWords.add((Object)entry, value);
            }
            for (i = 0; i < p.contextModel.numLocations(); ++i) {
                oldIndex = p.contextModel.indexAtLocation(i);
                value = p.contextModel.valueAtLocation(i);
                entry = (String)oldAlph.lookupObject(oldIndex);
                newContextModel.add((Object)entry, value);
            }
            p.keyWords = newKeyWords;
            p.contextModel = newContextModel;
            p.setAlphabet(this.alphabet);
        }
        return p;
    }

    public void expand() {
        Person[] people = this.id2person.values().toArray(new Person[0]);
        for (int i = 0; i < people.length; ++i) {
            Person person = people[i];
            if (!person.processedForWebPages || person.processedForContactInformation) continue;
            person.processedForContactInformation = true;
            ArrayList namesFromWeb = person.getContactRecord().getNames();
            for (int j = 0; j < namesFromWeb.size(); ++j) {
                CountedString name = (CountedString)namesFromWeb.get(j);
                Vector<CountedString> names = new Vector<CountedString>(1);
                names.add(new CountedString(name.str));
                Person newp = new Person(names, null, person.domains, null, null);
                newp.contextPages.add(person.pages.get(name.cnt));
                newp.addInLink(person.getId());
                this.addPerson(newp);
            }
        }
    }

    public boolean removePerson(Person p) {
        Iterator iiter = p.inLinks.iterator();
        while (iiter.hasNext()) {
            int index = (Integer)iiter.next();
            Person n = this.getPerson(index);
            if (n != null) continue;
            logger.info("WARNING: can't remove person " + index + " because it no longer exists");
        }
        return this.id2person.remove(new Integer(p.getId())) == null;
    }

    public boolean removePerson(String login) {
        Integer[] keys = this.id2person.keySet().toArray(new Integer[0]);
        boolean ret = false;
        for (int i = 0; i < keys.length; ++i) {
            Integer key = keys[i];
            Person person = (Person)this.id2person.get(key);
            if (person == null || !person.findLogin(login)) continue;
            this.removePerson(person);
            ret = true;
        }
        return ret;
    }

    public void stopKeyWords(HashSet stop) {
        Iterator iter = this.id2person.values().iterator();
        while (iter.hasNext()) {
            Person p = (Person)iter.next();
            p.stopKeyWords(stop);
        }
    }

    public void buildEmailLinks() {
        Iterator iter = this.id2person.values().iterator();
        while (iter.hasNext()) {
            Person p1 = (Person)iter.next();
            Iterator iter2 = this.id2person.values().iterator();
            while (iter2.hasNext()) {
                Person p2 = (Person)iter2.next();
                if (p1 == p2) continue;
                p1.addEmailLink(p2);
            }
        }
    }

    public int findPersonByName(String name) {
        Iterator iter = this.id2person.values().iterator();
        while (iter.hasNext()) {
            Person person = (Person)iter.next();
            if (!person.findName(name)) continue;
            return person.getId();
        }
        return -1;
    }

    public void writeToFile(File file) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            Iterator iter = this.id2person.values().iterator();
            while (iter.hasNext()) {
                ((Person)iter.next()).writeToFile(out);
            }
            out.close();
        }
        catch (IOException e) {
            System.out.print("Cannot open file ");
            System.out.println(file.getName());
        }
    }

    public void print() {
        Iterator iter = this.id2person.values().iterator();
        while (iter.hasNext()) {
            Person p = (Person)iter.next();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            pw.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            pw.println("Person Number " + p.getId());
            p.print(pw);
            System.out.print(sw.toString());
        }
    }

    public void write(File f) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(this);
            oos.close();
            logger.fine("Wrote " + this.size() + " People Successfully");
        }
        catch (IOException e) {
            logger.severe("Exception writing file " + f + ": " + e);
        }
    }

    public void writeHTML(File f) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            out.write("<html>\n<body><h2> Extracted Contact Information</h2>\n<br>\n<table border=1 cellspacing=3>\n");
            out.write("<tr><td> ID </td>\n");
            out.write("<td> First </td>\n");
            out.write("<td> Middle </td>\n");
            out.write("<td> Last </td>\n");
            out.write("<td> Email </td>\n");
            out.write("<td> URL </td>\n");
            out.write("<td> Suffix </td>\n");
            out.write("<td> Title </td>\n");
            out.write("<td> JobTitle </td>\n");
            out.write("<td> CompanyName </td>\n");
            out.write("<td> Department </td>\n");
            out.write("<td> AddressLine </td>\n");
            out.write("<td> City </td>\n");
            out.write("<td> State </td>\n");
            out.write("<td> Country </td>\n");
            out.write("<td> PostalCode </td>\n");
            out.write("<td> HomePhoneNumber </td>\n");
            out.write("<td> DirectPhoneNumber </td>\n");
            out.write("<td> MobilePhoneNumber </td>\n");
            out.write("<td> OutLinks </td>\n");
            out.write("<td> InLinks </td>\n");
            Iterator iter = this.id2person.values().iterator();
            while (iter.hasNext()) {
                ((Person)iter.next()).writeHTML(out, this);
            }
            out.write("</table>\n</body>\n<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br></html>");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            String msg = "Cannot open file " + f;
            logger.severe(msg + " : " + e);
            throw new DexRuntimeException(msg, e);
        }
    }

    public void writeTXT(File f) {
        this.writeToFile(f);
    }

    public void writeCSV(File f) {
        throw new UnsupportedOperationException("csv output not yet implemented");
    }

    public void writeVCF(File f) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            Iterator iter = this.id2person.values().iterator();
            while (iter.hasNext()) {
                ((Person)iter.next()).writeVCF(out, this);
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.print("Cannot open file " + f);
        }
    }

    public static People read(File f) {
        People ret = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
            ret = (People)ois.readObject();
            ois.close();
            logger.fine("Read " + ret.size() + " People successfully!");
        }
        catch (IOException e) {
            String msg = "Exception reading file: " + f;
            logger.severe(msg + " : " + e);
            throw new DexRuntimeException(msg, e);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = "Cound not find class reading in object from file: " + f;
            logger.severe(msg + " : " + cnfe);
            throw new DexRuntimeException(msg, cnfe);
        }
        return ret;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.id2person);
        out.writeObject(this.alphabet);
        out.writeInt(this.peopleAdded);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version < 1) {
            logger.severe("Version 0 serialization no longer supported\n");
        } else {
            this.id2person = (HashSetMap)in.readObject();
            this.alphabet = (Alphabet)in.readObject();
            this.peopleAdded = in.readInt();
        }
    }
}

