/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.dex.types;

import edu.umass.cs.dex.types.ContactRecord;
import edu.umass.cs.dex.types.CountedString;
import edu.umass.cs.dex.types.People;
import edu.umass.cs.dex.types.WeightedString;
import edu.umass.cs.dex.web.WebPage;
import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.AugmentableFeatureVector;
import edu.umass.cs.mallet.base.types.StringKernel;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Person
implements Serializable,
Comparable {
    private static Logger logger = MalletLogger.getLogger(Person.class.getName());
    public boolean processedForWebPages = false;
    public boolean processedForContactInformation = false;
    public Vector names = new Vector();
    public Vector logins = new Vector();
    public Vector domains = new Vector();
    public AugmentableFeatureVector keyWords;
    public ArrayList topKeyWords;
    public AugmentableFeatureVector contextModel;
    public Alphabet alphabet = new Alphabet();
    public HashMap emailLinks;
    public Vector pages;
    public Vector contextPages;
    public ContactRecord contactRecord;
    public HashSet inLinks;
    public HashSet outLinks;
    public int numberOfOccurrences = 1;
    private int id = -1;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public Person() {
        this.keyWords = new AugmentableFeatureVector(this.alphabet, 1, false);
        this.topKeyWords = new ArrayList();
        this.contextModel = new AugmentableFeatureVector(this.alphabet, 1, false);
        this.emailLinks = new HashMap();
        this.pages = new Vector();
        this.contextPages = new Vector();
        this.contactRecord = new ContactRecord();
        this.inLinks = new HashSet();
        this.outLinks = new HashSet();
    }

    public Person(String name, String login, String domain) {
        this();
        if (name != null) {
            this.names.addElement(new CountedString(name));
        }
        if (login != null) {
            this.logins.addElement(new CountedString(login));
        }
        if (domain != null) {
            this.domains.addElement(new CountedString(domain));
        }
    }

    public Person(Vector names_, Vector logins_, Vector domains_, AugmentableFeatureVector keyWords_, AugmentableFeatureVector contextModel_) {
        this();
        if (names_ != null) {
            this.names.addAll(names_);
        }
        if (logins_ != null) {
            this.logins.addAll(logins_);
        }
        if (domains_ != null) {
            this.domains.addAll(domains_);
        }
        if (keyWords_ != null) {
            this.keyWords = keyWords_;
            this.alphabet = this.keyWords.getAlphabet();
        }
        if (contextModel_ != null) {
            this.contextModel = contextModel_;
            if (keyWords_ != null && keyWords_.getAlphabet() != contextModel_.getAlphabet()) {
                throw new IllegalArgumentException("feature vector dictionaries don't match.");
            }
            this.alphabet = this.contextModel.getAlphabet();
        }
    }

    public Iterator pageIterator() {
        return this.pages.iterator();
    }

    public void addPage(WebPage webPage) {
        this.pages.add(webPage);
    }

    public int getNumberOfOccurrences() {
        return this.numberOfOccurrences;
    }

    public void setContactRecord(ContactRecord c) {
        this.contactRecord = c;
    }

    public ContactRecord getContactRecord() {
        return this.contactRecord;
    }

    public void setAlphabet(Alphabet a) {
        this.alphabet = a;
    }

    public HashSet getInLinks() {
        return this.inLinks;
    }

    public void addInLink(int i) {
        this.inLinks.add(new Integer(i));
    }

    public void addOutLink(int i) {
        this.outLinks.add(new Integer(i));
    }

    public void removeOutLink(int index) {
        this.outLinks.remove(new Integer(index));
    }

    public int getId() {
        return this.id;
    }

    public void setId(int i) {
        this.id = i;
    }

    public String getFirstName() {
        String name = null;
        if (this.names.size() > 0) {
            name = ((CountedString)this.names.elementAt((int)0)).str;
        }
        return name;
    }

    public boolean findName(String name1) {
        for (int i = 0; i < this.names.size(); ++i) {
            String name2 = ((CountedString)this.names.elementAt((int)i)).str;
            if (!Person.sameName(name1, name2)) continue;
            return true;
        }
        return false;
    }

    public String getSurname() {
        String surname = null;
        for (int i = 0; i < this.names.size(); ++i) {
            String[] words;
            String name = ((CountedString)this.names.elementAt((int)i)).str;
            Pattern pat = Pattern.compile(" ");
            Matcher mat = pat.matcher(name);
            if (!mat.find() || (words = pat.split(name)).length > 3) continue;
            surname = words[words.length - 1];
            break;
        }
        return surname;
    }

    public static boolean contains(Vector vec, String str) {
        for (int i = 0; i < vec.size(); ++i) {
            if (!((CountedString)vec.elementAt(i)).equals(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Vector vec, Integer g) {
        for (int i = 0; i < vec.size(); ++i) {
            if (!((Integer)vec.elementAt(i)).equals(g)) continue;
            return true;
        }
        return false;
    }

    public static void swapNeighbors(Vector vec, int ind) {
        CountedString cs = (CountedString)vec.elementAt(ind + 1);
        vec.add(ind, cs);
        vec.remove(ind + 2);
    }

    public static void incrementCounterAndSort(Vector vec, String str) {
        for (int i = 0; i < vec.size(); ++i) {
            if (!((CountedString)vec.elementAt(i)).equals(str)) continue;
            ++((CountedString)vec.elementAt((int)i)).cnt;
            for (int j = i - 1; j >= 0; --j) {
                if (((CountedString)vec.elementAt((int)(j + 1))).cnt <= ((CountedString)vec.elementAt((int)j)).cnt) continue;
                Person.swapNeighbors(vec, j);
            }
            return;
        }
    }

    public static boolean sameName(String name1, String name2) {
        Pattern pat = Pattern.compile(" ");
        String[] words1 = pat.split(name1);
        String[] words2 = pat.split(name2);
        int matches = 0;
        boolean longWordMatch = false;
        block0: for (int i = 0; i < words1.length; ++i) {
            for (int j = 0; j < words2.length; ++j) {
                if (words1[i].compareTo(words2[j]) == 0) {
                    ++matches;
                    words2[j] = "";
                    if (words1[i].length() <= 1 || 2 * j < words2.length) continue block0;
                    longWordMatch = true;
                    continue block0;
                }
                if (words1[i].length() != 1 && words2[j].length() != 1 || i >= words1.length - 1 || j >= words2.length - 1 || !words1[i].regionMatches(0, words2[j], 0, 1)) continue;
                ++matches;
                words2[j] = "";
                continue block0;
            }
        }
        return longWordMatch && matches > 1 && words1.length < 2 * matches && words2.length < 2 * matches;
    }

    public static Vector mergeVectors(Vector v1, Vector v2) {
        for (int i = 0; i < v2.size(); ++i) {
            String str = ((CountedString)v2.elementAt((int)i)).str;
            if (str == null) continue;
            if (!Person.contains(v1, str)) {
                v1.add(new CountedString(str));
                continue;
            }
            Person.incrementCounterAndSort(v1, str);
        }
        return v1;
    }

    public static String cleanURL(String url) {
        Pattern pat = Pattern.compile("^(.+\\/\\~[^\\/]+)\\/.*$");
        Matcher mat = pat.matcher(url);
        if (mat.matches()) {
            url = mat.group(1);
        }
        if ((mat = (pat = Pattern.compile("^(.+)\\.\\w+$")).matcher(url)).matches()) {
            url = mat.group(1);
        }
        return url;
    }

    public boolean isLoginOrNameInURL(String url, String threadName) {
        double STRING_KERNEL_THRESHOLD = 0.75;
        StringKernel sk = new StringKernel();
        url = Person.cleanURL(url);
        Pattern pat = Pattern.compile("[\\/\\~]");
        String[] fields = pat.split(url);
        for (int i = 0; i < fields.length; ++i) {
            int j;
            String field = fields[i].toLowerCase();
            if (field.length() < 2 || field.length() > 30) continue;
            for (j = 0; j < this.logins.size(); ++j) {
                String login = ((CountedString)this.logins.elementAt((int)j)).str;
                if (login.equals(field)) {
                    return true;
                }
                pat = Pattern.compile("[\\._]");
                String[] words = pat.split(login);
                for (int k = 0; k < words.length; ++k) {
                    if (!words[k].equals(field)) continue;
                    return true;
                }
            }
            for (j = 0; j < this.names.size(); ++j) {
                String name = ((CountedString)this.names.elementAt((int)j)).str;
                double value = sk.K(name, field);
                if (value > STRING_KERNEL_THRESHOLD && field.length() > 3) {
                    return true;
                }
                pat = Pattern.compile(" ");
                String[] words = pat.split(name);
                for (int k = 0; k < words.length; ++k) {
                    if (words[k].equals(field)) {
                        return true;
                    }
                    value = sk.K(words[k], field);
                    if (!(value > STRING_KERNEL_THRESHOLD) || field.length() <= 3 || words[k].length() <= 3) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean findLogin(String login) {
        return Person.contains(this.logins, login);
    }

    public boolean loginsIntersect(Person person) {
        for (int i = 0; i < person.logins.size(); ++i) {
            String name;
            Person p;
            String login = ((CountedString)person.logins.elementAt((int)i)).str;
            if (Person.contains(this.logins, login)) {
                return true;
            }
            Pattern pat = Pattern.compile("[_\\.]");
            Matcher mat = pat.matcher(login);
            if (!mat.find() || !this.namesIntersect(p = new Person(name = mat.replaceFirst(" "), "", ""))) continue;
            return true;
        }
        return false;
    }

    private boolean similarNames(String n1, String n2) {
        if (n1.equalsIgnoreCase(n2)) {
            return true;
        }
        String[] names = n1.split("\\s+");
        String[] newNames = n2.split("\\s+");
        if (names.length < 2 || newNames.length < 2) {
            return false;
        }
        String fname = names[0];
        String lname = names[names.length - 1];
        String newfname = newNames[0];
        String newlname = newNames[newNames.length - 1];
        if (fname.charAt(0) == newfname.charAt(0) && lname.equalsIgnoreCase(newlname)) {
            logger.fine("RESOLVING COREFERENCE " + n1 + " <-> " + n2);
            return true;
        }
        return false;
    }

    public boolean namesIntersect(Person person) {
        for (int i = 0; i < person.names.size(); ++i) {
            String name1 = ((CountedString)person.names.elementAt((int)i)).str;
            for (int j = 0; j < this.names.size(); ++j) {
                String name2 = ((CountedString)this.names.elementAt((int)j)).str;
                if (!Person.sameName(name1, name2) && !this.similarNames(name1, name2)) continue;
                return true;
            }
            Pattern pat = Pattern.compile(" ");
            Matcher mat = pat.matcher(name1);
            if (!mat.find()) continue;
            String login = mat.replaceAll("\\.");
            if (Person.contains(this.logins, login)) {
                return true;
            }
            login = mat.replaceAll("\\_");
            if (!Person.contains(this.logins, login)) continue;
            return true;
        }
        return false;
    }

    public void addKeyWord(String word) {
        this.addKeyWords(new String[]{word});
    }

    public void addKeyWords(String[] _words) {
        this.addWords(_words, this.keyWords);
    }

    public void addWordToContextModel(String word) {
        this.addWordToContextModel(word, 1.0);
    }

    public void addWordToContextModel(String word, double val) {
        this.addWordsToContextModel(new String[]{word}, new double[]{val});
    }

    public void addWordsToContextModel(String[] _words) {
        this.addWords(_words, this.contextModel);
    }

    public void addWordsToContextModel(String[] _words, double[] weights) {
        this.addWords(_words, this.contextModel, weights);
    }

    public void addWords(String[] toadd, AugmentableFeatureVector words) {
        if (words == null) {
            words = new AugmentableFeatureVector(this.alphabet);
        }
        for (int i = 0; i < toadd.length; ++i) {
            words.add((Object)toadd[i], 1.0);
        }
    }

    public void addWords(String[] toadd, AugmentableFeatureVector words, double[] weights) {
        if (words == null) {
            words = new AugmentableFeatureVector(this.alphabet);
        }
        if (weights.length != toadd.length) {
            throw new IllegalArgumentException("tadd.size: " + toadd.length + ", weights.size: " + weights.length);
        }
        for (int i = 0; i < toadd.length; ++i) {
            words.add((Object)toadd[i], weights[i]);
        }
    }

    public void stopKeyWords(HashSet stop) {
        String[] keys = stop.toArray(new String[0]);
        AugmentableFeatureVector stoplist = new AugmentableFeatureVector(this.alphabet);
        this.addWords(keys, stoplist);
        for (int i = 0; i < stoplist.numLocations(); ++i) {
            int index = stoplist.indexAtLocation(i);
            this.keyWords.setValue(index, 0.0);
        }
    }

    public void removePage(String fileName) {
        for (int i = 0; i < this.pages.size(); ++i) {
            WebPage webPage = (WebPage)this.pages.elementAt(i);
            if (!webPage.fileName.equals(fileName)) continue;
            this.pages.removeElementAt(i);
            break;
        }
    }

    public void addEmailLink(String name, int value) {
        Integer counter = (Integer)this.emailLinks.get(name);
        if (counter != null) {
            int newCounter = counter + value;
            this.emailLinks.put(name, new Integer(newCounter));
        } else {
            this.emailLinks.put(name, new Integer(value));
        }
    }

    public void addEmailLink(Person p) {
        String name = p.getFirstName();
        if (name == null) {
            return;
        }
        this.addEmailLink(name, 1);
    }

    public double calculateCosineWithContextModel(String[] model) {
        if (model == null || this.contextModel == null) {
            return 1.0;
        }
        AugmentableFeatureVector tocompare = new AugmentableFeatureVector(this.alphabet);
        this.addWords(model, tocompare);
        double tocompareTwoNorm = tocompare.twoNorm();
        double contextTwoNorm = this.contextModel.twoNorm();
        if (tocompareTwoNorm == 0.0 || contextTwoNorm == 0.0) {
            return 1.0;
        }
        return tocompare.dotProduct(this.contextModel) / (tocompareTwoNorm * contextTwoNorm);
    }

    public double calculateCosineWithKeyWords(String[] model) {
        if (model == null || this.keyWords == null) {
            return 0.0;
        }
        AugmentableFeatureVector tocompare = new AugmentableFeatureVector(this.alphabet);
        this.addWords(model, tocompare);
        return this.calculateCosineWithKeyWords(tocompare);
    }

    public double calculateCosineWithKeyWords(AugmentableFeatureVector tocompare) {
        double tocompareTwoNorm = tocompare.twoNorm();
        double keyWordsTwoNorm = this.keyWords.twoNorm();
        if (tocompareTwoNorm == 0.0 || keyWordsTwoNorm == 0.0) {
            return 0.0;
        }
        return tocompare.dotProduct(this.keyWords) / (keyWordsTwoNorm * tocompareTwoNorm);
    }

    private AugmentableFeatureVector mergeFeatureVectors(AugmentableFeatureVector v1, AugmentableFeatureVector v2) {
        if (v2 != null) {
            if (v1 == null) {
                v1 = v2;
            } else {
                v1.plusEquals(v2, 1.0);
            }
        }
        return v1;
    }

    public void mergeTwoPeople(Person person) {
        this.names = Person.mergeVectors(this.names, person.names);
        this.logins = Person.mergeVectors(this.logins, person.logins);
        this.domains = Person.mergeVectors(this.domains, person.domains);
        this.contextModel = this.mergeFeatureVectors(this.contextModel, person.contextModel);
        this.keyWords = this.mergeFeatureVectors(this.keyWords, person.keyWords);
        this.processedForWebPages = person.processedForWebPages ? true : this.processedForWebPages;
        this.processedForContactInformation = person.processedForContactInformation ? true : this.processedForContactInformation;
        this.emailLinks.putAll(person.emailLinks);
        this.contextPages.addAll(person.contextPages);
        this.pages.addAll(person.pages);
        this.numberOfOccurrences += person.getNumberOfOccurrences();
        this.outLinks.addAll(person.outLinks);
        this.inLinks.addAll(person.inLinks);
    }

    private Vector mergeLinks(Vector links, Vector newLinks) {
        Vector<Integer> ret = new Vector<Integer>();
        for (int i = 0; i < links.size(); ++i) {
            Integer l1 = (Integer)links.get(i);
            if (!Person.contains(ret, l1)) {
                ret.add(l1);
            }
            for (int j = 0; j < newLinks.size(); ++j) {
                Integer l2 = (Integer)newLinks.get(j);
                if (Person.contains(ret, l2)) continue;
                ret.add(l2);
            }
        }
        return ret;
    }

    public void setTopKeyWordWeights(ArrayList sortedWords) {
        this.topKeyWords = sortedWords;
    }

    public void writeToFilePersonalInfo(BufferedWriter out) {
        try {
            int i;
            out.write("Person:");
            out.newLine();
            out.write("\tNames:");
            for (i = 0; i < this.names.size(); ++i) {
                if (i > 0) {
                    out.write(",");
                }
                out.write(" " + this.names.elementAt(i));
            }
            out.newLine();
            out.write("\tLogins:");
            for (i = 0; i < this.logins.size(); ++i) {
                if (i > 0) {
                    out.write(",");
                }
                out.write(" " + this.logins.elementAt(i));
            }
            out.newLine();
            out.write("\tDomains:");
            for (i = 0; i < this.domains.size(); ++i) {
                if (i > 0) {
                    out.write(",");
                }
                out.write(" " + this.domains.elementAt(i));
            }
            out.newLine();
            out.write("\tInLinks: " + this.inLinks);
            out.newLine();
            out.write("\tOutLinks:" + this.outLinks);
            out.newLine();
            out.write("\tContactRecord:" + this.contactRecord);
            out.newLine();
        }
        catch (IOException e) {
            logger.severe("Cannot write to file: " + e);
        }
    }

    public void writeToFile(BufferedWriter out) {
        try {
            this.writeToFilePersonalInfo(out);
            out.write("\tWords:");
            if (this.keyWords != null && this.keyWords.numLocations() > 0) {
                out.write(this.keyWords.toString(true));
            }
            out.newLine();
        }
        catch (IOException e) {
            logger.severe("Cannot write to file: " + e);
        }
    }

    public void writeHTML(BufferedWriter out, People people) {
        try {
            if (this.contactRecord == null || this.names.size() == 0) {
                return;
            }
            String[] names = this.getNames();
            if (names == null) {
                return;
            }
            int currIndex = this.id;
            String anchor = "<a name=\"" + currIndex + "\"></a> ";
            out.write("<tr><td>" + anchor + currIndex + "</td>");
            out.write("<td>" + names[0] + "</td>");
            out.write("<td>" + names[1] + "</td>");
            out.write("<td>" + names[2] + "</td>");
            String email = this.getEmail();
            out.write("<td>" + (email == null ? "&nbsp;" : email) + "</td>");
            String url = this.getURL();
            out.write("<td><a href=\"" + (url == null ? "&nbsp;" : url) + "\"> " + (url == null ? "&nbsp;" : url) + "</a></td>");
            String[] fields = this.getFields(new String[]{"Suffix", "Title", "JobTitle", "CompanyName", "Department", "AddressLine", "City1", "State", "Country", "PostalCode", "HomePhoneNumber", "DirectPhoneNumber", "MobilePhoneNumber"});
            for (int i = 0; i < fields.length; ++i) {
                out.write("<td>" + (fields[i] == null ? "&nbsp;" : fields[i]) + "</td>");
            }
            out.write("<td>");
            Iterator oiter = this.outLinks.iterator();
            while (oiter.hasNext()) {
                Person p = people.getPerson((Integer)oiter.next());
                out.write("<a href=\"#" + p.getId() + "\">" + p.getFirstName() + "</a><br>");
            }
            out.write("</td>");
            out.write("<td>");
            Iterator iiter = this.inLinks.iterator();
            while (iiter.hasNext()) {
                Person p = people.getPerson((Integer)iiter.next());
                out.write("<a href=\"#" + p.getId() + "\">" + p.getFirstName() + "</a><br>");
            }
            HashSet pageSet = new HashSet(this.contextPages);
            iiter = pageSet.iterator();
            int ci = 1;
            while (iiter.hasNext()) {
                out.write("<a href=\"" + ((WebPage)iiter.next()).url + "\">" + ci++ + "</a> ");
            }
            out.write("</td>");
            out.write("</tr>\n");
        }
        catch (IOException e) {
            logger.severe("Cannot write to file: " + e);
        }
    }

    public void writeCSV(BufferedWriter out, People people) {
    }

    public void writeVCF(BufferedWriter out, People people) {
        try {
            if (this.contactRecord == null) {
                return;
            }
            if (this.names.size() == 0) {
                return;
            }
            String[] names = this.getNames();
            if (names == null) {
                return;
            }
            out.write("BEGIN:VCARD\nVERSION:3.0\n");
            out.write("N: " + names[2] + ";" + names[0] + ";" + names[1] + ";" + this.contactRecord.getFirstValue("Title") + "\n");
            String email = this.contactRecord.getFirstValue("Email");
            if (this.logins.size() > 0 && this.domains.size() > 0) {
                email = ((CountedString)this.logins.get((int)0)).str + "@" + ((CountedString)this.domains.get((int)0)).str;
            }
            out.write("EMAIL;Internet: " + email + "\n");
            String url = this.contactRecord.getFirstValue("WebPageURL");
            if (this.pages.size() > 0) {
                url = ((WebPage)this.pages.get((int)0)).url;
            }
            out.write("URL: " + url + "\n");
            out.write("TITLE: " + this.contactRecord.getFirstValue("JobTitle") + "\n");
            out.write("ORG: " + this.contactRecord.getFirstValue("CompanyName") + ";" + this.contactRecord.getFirstValue("Department") + "\n");
            out.write("ADR;TYPE=POSTAL:;;" + this.contactRecord.getFirstValue("AddressLine") + ";" + this.contactRecord.getFirstValue("City1") + ";" + this.contactRecord.getFirstValue("State") + ";" + this.contactRecord.getFirstValue("PostalCode") + "\n");
            out.write("TEL;Home:" + this.contactRecord.getFirstValue("HomePhoneNumber") + "\n");
            out.write("TEL;Fax:" + this.contactRecord.getFirstValue("FaxNumber") + "\n");
            out.write("TEL;Work:" + this.contactRecord.getFirstValue("DirectPhoneNumber") + "\n");
            out.write("TEL;Voice:" + this.contactRecord.getFirstValue("CompanyPhoneNumber") + "\n");
            out.write("TEL;Cell:" + this.contactRecord.getFirstValue("MobilePhoneNumber") + "\n");
            Iterator oiter = this.outLinks.iterator();
            while (oiter.hasNext()) {
                Person p = people.getPerson((Integer)oiter.next());
                out.write("item1.X-ABRELATEDNAMES;type=pref:" + p.getFirstName() + "\nitem1.X-ABLabel:_$!<Friend>!$_\n");
            }
            Iterator iiter = this.inLinks.iterator();
            while (iiter.hasNext()) {
                Person p = people.getPerson((Integer)iiter.next());
                out.write("item2.X-ABRELATEDNAMES:" + p.getFirstName() + "\nitem2.X-ABLabel:PointedFrom\n");
            }
            String topWords = "";
            for (int fi = 0; this.topKeyWords != null && fi < 10 && fi < this.topKeyWords.size(); ++fi) {
                WeightedString s = (WeightedString)this.topKeyWords.get(fi);
                topWords = topWords + s.str + " . ";
            }
            out.write("NOTE: " + topWords + "\n");
            out.write("END:VCARD\n");
        }
        catch (IOException e) {
            logger.severe("Cannot write to file: " + e);
        }
    }

    public String[] getFields(String[] fields) {
        String[] ret = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            ret[i] = this.contactRecord.getFirstValue(fields[i]);
            if (ret[i] == null) continue;
            ret[i].replaceAll(",", " ");
        }
        return ret;
    }

    public String getURL() {
        String url = this.contactRecord.getFirstValue("WebPageURL");
        if (this.pages.size() > 0) {
            url = ((WebPage)this.pages.get((int)0)).url;
        }
        return url;
    }

    public String getEmail() {
        String email = this.contactRecord.getFirstValue("Email");
        if (this.logins.size() > 0 && this.domains.size() > 0) {
            email = ((CountedString)this.logins.get((int)0)).str + "@" + ((CountedString)this.domains.get((int)0)).str;
        }
        return email;
    }

    public String[] getNames() {
        String[] ret = new String[3];
        String[] names = this.getFirstName().split(" ");
        if ((names = Person.firstLetterCapital(names)).length == 3) {
            return names;
        }
        if (names.length == 2) {
            ret[0] = names[0];
            ret[1] = "";
            ret[2] = names[1];
            return ret;
        }
        return null;
    }

    public static String[] firstLetterCapital(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            String start = names[i].substring(0, 1);
            String rest = names[i].substring(1);
            names[i] = start.toUpperCase() + rest;
        }
        return names;
    }

    public void printPersonalInfo(PrintWriter pw) {
        int i;
        pw.println("Person:");
        pw.print("\tNames:");
        for (i = 0; i < this.names.size(); ++i) {
            if (i > 0) {
                pw.print(",");
            }
            pw.print(" " + this.names.elementAt(i));
        }
        pw.println();
        pw.print("\tLogins:");
        for (i = 0; i < this.logins.size(); ++i) {
            if (i > 0) {
                pw.print(",");
            }
            pw.print(" " + this.logins.elementAt(i));
        }
        pw.println();
        pw.print("\tDomains:");
        for (i = 0; i < this.domains.size(); ++i) {
            if (i > 0) {
                pw.print(",");
            }
            pw.print(" " + this.domains.elementAt(i));
        }
        pw.println();
        pw.println("\tNumber of occurrences: " + this.numberOfOccurrences);
        pw.println("\tInLinks: " + this.inLinks);
        pw.print("\tOutLinks: " + this.outLinks);
        pw.println();
    }

    public void print(PrintWriter pw) {
        this.printPersonalInfo(pw);
        pw.print("\tWords:" + this.keyWords);
        pw.println();
    }

    public String toString() {
        String name = this.getFirstName();
        if (name == null) {
            name = this.logins.size() > 0 ? ((CountedString)this.logins.get((int)0)).str : "null";
        }
        return name + "(" + this.id + ")";
    }

    public int compareTo(Object o) {
        return this.id - ((Person)o).getId();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int i;
        out.writeInt(0);
        out.writeBoolean(this.processedForWebPages);
        out.writeBoolean(this.processedForContactInformation);
        int size = this.names.size();
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            out.writeObject(this.names.get(i));
        }
        size = this.logins.size();
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            out.writeObject(this.logins.get(i));
        }
        size = this.domains.size();
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            out.writeObject(this.domains.get(i));
        }
        out.writeObject(this.keyWords);
        size = this.topKeyWords.size();
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            out.writeObject(this.topKeyWords.get(i));
        }
        out.writeObject(this.contextModel);
        out.writeObject(this.alphabet);
        out.writeObject(this.emailLinks);
        size = this.pages.size();
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            out.writeObject(this.pages.get(i));
        }
        size = this.contextPages.size();
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            out.writeObject(this.contextPages.get(i));
        }
        out.writeObject(this.contactRecord);
        out.writeObject(this.inLinks);
        out.writeObject(this.outLinks);
        out.writeInt(this.numberOfOccurrences);
        out.writeInt(this.id);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int i;
        int version = in.readInt();
        this.processedForWebPages = in.readBoolean();
        this.processedForContactInformation = in.readBoolean();
        int size = in.readInt();
        this.names = new Vector(size);
        for (i = 0; i < size; ++i) {
            this.names.add((CountedString)in.readObject());
        }
        size = in.readInt();
        this.logins = new Vector(size);
        for (i = 0; i < size; ++i) {
            this.logins.add((CountedString)in.readObject());
        }
        size = in.readInt();
        this.domains = new Vector(size);
        for (i = 0; i < size; ++i) {
            this.domains.add((CountedString)in.readObject());
        }
        this.keyWords = (AugmentableFeatureVector)in.readObject();
        size = in.readInt();
        this.topKeyWords = new ArrayList(size);
        for (i = 0; i < size; ++i) {
            this.topKeyWords.add((WeightedString)in.readObject());
        }
        this.contextModel = (AugmentableFeatureVector)in.readObject();
        this.alphabet = (Alphabet)in.readObject();
        this.emailLinks = (HashMap)in.readObject();
        size = in.readInt();
        this.pages = new Vector(size);
        for (i = 0; i < size; ++i) {
            this.pages.add((WebPage)in.readObject());
        }
        size = in.readInt();
        this.contextPages = new Vector(size);
        for (i = 0; i < size; ++i) {
            this.contextPages.add((WebPage)in.readObject());
        }
        this.contactRecord = (ContactRecord)in.readObject();
        this.inLinks = (HashSet)in.readObject();
        this.outLinks = (HashSet)in.readObject();
        this.numberOfOccurrences = in.readInt();
        this.id = in.readInt();
    }
}

