/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.python.core.Py;
import org.python.core.PyDescriptor;
import org.python.core.PyObject;
import org.python.core.PyType;

public class PyFieldDescr
extends PyDescriptor {
    private Field field;
    private Class field_type;
    private boolean readonly;

    public PyFieldDescr(String name, Class c, String field_name) {
        this(name, c, field_name, false);
    }

    public PyFieldDescr(String name, Class c, String field_name, boolean readonly) {
        this.name = name;
        this.dtype = PyType.fromClass(c);
        try {
            this.field = c.getField(field_name);
        }
        catch (NoSuchFieldException e) {
            throw Py.SystemError("bogus attribute spec");
        }
        int modifiers = this.field.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            throw Py.SystemError("static attributes not supported");
        }
        this.readonly = readonly || Modifier.isFinal(modifiers);
        this.field_type = this.field.getType();
    }

    public String toString() {
        return "<member '" + this.name + "' of '" + this.dtype.fastGetName() + "' objects>";
    }

    public PyObject __get__(PyObject obj, PyObject type) {
        try {
            if (obj != null) {
                PyType objtype = obj.getType();
                if (objtype != this.dtype && !objtype.isSubType(this.dtype)) {
                    throw this.get_wrongtype(objtype);
                }
                return Py.java2py(this.field.get(obj));
            }
            return this;
        }
        catch (IllegalArgumentException e) {
            throw Py.JavaError(e);
        }
        catch (IllegalAccessException e) {
            throw Py.JavaError(e);
        }
    }

    public void __set__(PyObject obj, PyObject value) {
        try {
            PyType objtype = obj.getType();
            if (objtype != this.dtype && !objtype.isSubType(this.dtype)) {
                throw this.get_wrongtype(objtype);
            }
            Object converted = value.__tojava__(this.field_type);
            if (converted == Py.NoConversion) {
                throw Py.TypeError("");
            }
            this.field.set(obj, converted);
        }
        catch (IllegalArgumentException e) {
            throw Py.JavaError(e);
        }
        catch (IllegalAccessException e) {
            throw Py.JavaError(e);
        }
    }

    public boolean implementsDescrSet() {
        return !this.readonly;
    }

    public boolean isDataDescr() {
        return true;
    }
}

