/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.util.Hashtable;
import java.util.Vector;
import org.javacc.jjtree.ASTGrammar;
import org.javacc.jjtree.ASTNodeDescriptor;
import org.javacc.jjtree.IO;
import org.javacc.jjtree.JJTreeGlobals;
import org.javacc.jjtree.JJTreeIOException;
import org.javacc.jjtree.JJTreeParser;
import org.javacc.jjtree.JJTreeState;
import org.javacc.jjtree.NodeFiles;
import org.javacc.jjtree.ParseException;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.Main;
import org.javacc.parser.Options;

public class JJTree {
    private IO io;

    private void p(String s) {
        this.io.getMsg().println(s);
    }

    private void help_message() {
        this.p("Usage:");
        this.p("    jjtree option-settings inputfile");
        this.p("");
        this.p("\"option-settings\" is a sequence of settings separated by spaces.");
        this.p("Each option setting must be of one of the following forms:");
        this.p("");
        this.p("    -optionname=value (e.g., -STATIC=false)");
        this.p("    -optionname:value (e.g., -STATIC:false)");
        this.p("    -optionname       (equivalent to -optionname=true.  e.g., -STATIC)");
        this.p("    -NOoptionname     (equivalent to -optionname=false. e.g., -NOSTATIC)");
        this.p("");
        this.p("Option settings are not case-sensitive, so one can say \"-nOsTaTiC\" instead");
        this.p("of \"-NOSTATIC\".  Option values must be appropriate for the corresponding");
        this.p("option, and must be either an integer or a string value.");
        this.p("");
        this.p("The boolean valued options are:");
        this.p("");
        this.p("    STATIC                 (default true)");
        this.p("    MULTI                  (default false)");
        this.p("    NODE_DEFAULT_VOID      (default false)");
        this.p("    NODE_SCOPE_HOOK        (default false)");
        this.p("    NODE_FACTORY           (default false)");
        this.p("    NODE_USES_PARSER       (default false)");
        this.p("    BUILD_NODE_FILES       (default true)");
        this.p("    VISITOR                (default false)");
        this.p("");
        this.p("The string valued options are:");
        this.p("");
        this.p("    NODE_PREFIX            (default \"AST\")");
        this.p("    NODE_PACKAGE           (default \"\")");
        this.p("    OUTPUT_FILE            (default remove input file suffix, add .jj)");
        this.p("    OUTPUT_DIRECTORY       (default \"\")");
        this.p("    VISITOR_EXCEPTION      (default \"\")");
        this.p("");
        this.p("JJTree also accepts JavaCC options, which it inserts into the generated file.");
        this.p("");
        this.p("EXAMPLES:");
        this.p("    jjtree -STATIC=false mygrammar.jjt");
        this.p("");
        this.p("ABOUT JJTree:");
        this.p("    JJTree is a preprocessor for JavaCC that inserts actions into a");
        this.p("    JavaCC grammar to build parse trees for the input.");
        this.p("");
        this.p("    For more information, ???");
        this.p("");
    }

    private boolean isOption(String opt) {
        return opt.length() > 1 && opt.charAt(0) == '-';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int main(String[] args) {
        ASTNodeDescriptor.nodeIds = new Vector();
        ASTNodeDescriptor.nodeNames = new Vector();
        ASTNodeDescriptor.nodeSeen = new Hashtable();
        JJTreeGlobals.jjtreeOptions = new Hashtable();
        JJTreeGlobals.toolList = new Vector();
        JJTreeGlobals.parserName = null;
        JJTreeGlobals.packageName = "";
        JJTreeGlobals.parserImplements = null;
        JJTreeGlobals.parserClassBodyStart = null;
        JJTreeGlobals.productions = new Hashtable();
        Main.reInitAll();
        JavaCCGlobals.bannerLine("Tree Builder", "");
        this.io = new IO();
        try {
            this.initializeOptions();
            if (args.length == 0) {
                this.p("");
                this.help_message();
                int n = 1;
                Object var8_4 = null;
                this.io.closeAll();
                return n;
            }
            this.p("(type \"jjtree\" with no arguments for help)");
            String fn = args[args.length - 1];
            if (this.isOption(fn)) {
                this.p("Last argument \"" + fn + "\" is not a filename");
                int n = 1;
                Object var8_5 = null;
                this.io.closeAll();
                return n;
            }
            int arg = 0;
            while (arg < args.length - 1) {
                if (!this.isOption(args[arg])) {
                    this.p("Argument \"" + args[arg] + "\" must be an option setting.");
                    int n = 1;
                    Object var8_6 = null;
                    this.io.closeAll();
                    return n;
                }
                Options.setCmdLineOption(args[arg]);
                ++arg;
            }
            try {
                this.io.setInput(fn);
            }
            catch (JJTreeIOException ioe) {
                this.p("Error setting input: " + ioe.getMessage());
                int n = 1;
                Object var8_7 = null;
                this.io.closeAll();
                return n;
            }
            this.p("Reading from file " + this.io.getInputFileName() + " . . .");
            JJTreeGlobals.toolList = JavaCCGlobals.getToolNames(fn);
            JJTreeGlobals.toolList.addElement("JJTree");
            try {
                JJTreeParser parser = new JJTreeParser(this.io.getIn());
                parser.javacc_input();
                ASTGrammar root = (ASTGrammar)parser.jjtree.rootNode();
                if (Boolean.getBoolean("jjtree-dump")) {
                    root.dump(" ");
                }
                root.generate(this.io);
                this.io.getOut().close();
                NodeFiles.generateTreeConstants_java();
                NodeFiles.generateVisitor_java();
                JJTreeState.generateTreeState_java();
                this.p("Annotated grammar generated successfully in " + this.io.getOutputFileName());
            }
            catch (ParseException pe) {
                this.p("Error parsing input: " + pe.toString());
                int root = 1;
                Object var8_8 = null;
                this.io.closeAll();
                return root;
            }
            catch (Exception e) {
                this.p("Error parsing input: " + e.toString());
                e.printStackTrace(this.io.getMsg());
                int n = 1;
                Object var8_9 = null;
                this.io.closeAll();
                return n;
            }
            int n = 0;
            Object var8_10 = null;
            this.io.closeAll();
            return n;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.io.closeAll();
            throw throwable;
        }
    }

    private void initializeOptions() {
        Options.JavaCCInit();
        Options.optionValues.put("MULTI", Boolean.FALSE);
        Options.optionValues.put("NODE_DEFAULT_VOID", Boolean.FALSE);
        Options.optionValues.put("NODE_SCOPE_HOOK", Boolean.FALSE);
        Options.optionValues.put("NODE_FACTORY", Boolean.FALSE);
        Options.optionValues.put("NODE_USES_PARSER", Boolean.FALSE);
        Options.optionValues.put("BUILD_NODE_FILES", Boolean.TRUE);
        Options.optionValues.put("VISITOR", Boolean.FALSE);
        Options.optionValues.put("NODE_PREFIX", "AST");
        Options.optionValues.put("NODE_PACKAGE", "");
        Options.optionValues.put("OUTPUT_FILE", "");
        Options.optionValues.put("OUTPUT_DIRECTORY", "");
        Options.optionValues.put("VISITOR_EXCEPTION", "");
        Options.optionValues.put("NODE_STACK_SIZE", new Integer(500));
        Options.optionValues.put("CHECK_DEFINITE_NODE", Boolean.TRUE);
        JJTreeGlobals.jjtreeOptions.put("MULTI", Boolean.FALSE);
        JJTreeGlobals.jjtreeOptions.put("NODE_PREFIX", "AST");
        JJTreeGlobals.jjtreeOptions.put("NODE_PACKAGE", "");
        JJTreeGlobals.jjtreeOptions.put("NODE_STACK_SIZE", new Integer(500));
        JJTreeGlobals.jjtreeOptions.put("NODE_DEFAULT_VOID", Boolean.FALSE);
        JJTreeGlobals.jjtreeOptions.put("OUTPUT_FILE", "");
        JJTreeGlobals.jjtreeOptions.put("OUTPUT_DIRECTORY", "");
        JJTreeGlobals.jjtreeOptions.put("CHECK_DEFINITE_NODE", Boolean.TRUE);
        JJTreeGlobals.jjtreeOptions.put("NODE_SCOPE_HOOK", Boolean.FALSE);
        JJTreeGlobals.jjtreeOptions.put("NODE_FACTORY", Boolean.FALSE);
        JJTreeGlobals.jjtreeOptions.put("NODE_USES_PARSER", Boolean.FALSE);
        JJTreeGlobals.jjtreeOptions.put("BUILD_NODE_FILES", Boolean.TRUE);
        JJTreeGlobals.jjtreeOptions.put("VISITOR", Boolean.FALSE);
        JJTreeGlobals.jjtreeOptions.put("VISITOR_EXCEPTION", "");
    }
}

