/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.dex.web;

import edu.umass.cs.mallet.base.util.MalletLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class LicenseKeyManager {
    private static Logger logger;
    private File licenseExpirationFile;
    private List licenses;
    private License currentLicenseKey;
    private String licenseFileAccessCode;
    private static LicenseKeyManager instance;
    private String usersLicenseFileAccessCode;
    public static final long DEFAULT_EXPIRATION_PERIOD = 86400000L;
    private long expirationPeriod = 86400000L;
    private static final Long ZERO_VALUE_LONG;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static synchronized void initialize(File licenseKeyFile, String licenseFileAccessCode) {
        if (instance != null) {
            throw new IllegalStateException("Singleton is already initialized.");
        }
        instance = new LicenseKeyManager(licenseKeyFile, licenseFileAccessCode);
    }

    public static synchronized void clear(boolean deleteExpirationFile) {
        LicenseKeyManager lkm = instance;
        instance = null;
        if (deleteExpirationFile && lkm != null && lkm.licenseExpirationFile != null) {
            lkm.licenseExpirationFile.delete();
        }
        logger.warning(LicenseKeyManager.class.getName() + ".clear() called - the singleton has been released.");
    }

    public static synchronized LicenseKeyManager getInstance() {
        if (instance != null) {
            return instance;
        }
        throw new IllegalStateException("Singleton is not yet initialized");
    }

    private LicenseKeyManager(File licenseKeyFile, String licenseFileAccessCode) {
        if (!$assertionsDisabled && licenseFileAccessCode == null) {
            throw new AssertionError();
        }
        this.licenseFileAccessCode = licenseFileAccessCode;
        this.licenseExpirationFile = new File(licenseKeyFile.toString() + ".ser");
        this.licenses = this.createLicenseList(LicenseKeyManager.readLicenseKeyFile(licenseKeyFile));
        this.currentLicenseKey = (License)this.licenses.get(0);
    }

    private List createLicenseList(List licenseKeyStrings) {
        Map licStrToExpirationTimeMap = LicenseKeyManager.loadExpiredLicenseKeys(this.licenseExpirationFile);
        ArrayList<License> licenseList = new ArrayList<License>();
        HashSet<String> licenseStringSet = new HashSet<String>();
        long curTime = System.currentTimeMillis();
        for (int i = 0; i < licenseKeyStrings.size(); ++i) {
            String licKey = (String)licenseKeyStrings.get(i);
            if (!licenseStringSet.add(licKey)) continue;
            License license = new License(licKey);
            Long expirationTime = this.getPersistedExpirationTime(licStrToExpirationTimeMap, licKey);
            long et = expirationTime;
            if (et > 0L && et < curTime && et + this.expirationPeriod > curTime) {
                license.setTimeExpired(et);
            }
            licenseList.add(license);
        }
        return licenseList;
    }

    private Long getPersistedExpirationTime(Map map, String key) {
        Long expirationTime = ZERO_VALUE_LONG;
        try {
            Long value = (Long)map.get(key);
            if (value != null) {
                expirationTime = value;
            }
        }
        catch (Throwable e) {
            logger.warning("Invalid data found in serialized license key Map: " + e);
        }
        return expirationTime;
    }

    public License getLicenseKey() {
        return this.isUserLicensed() ? this.currentLicenseKey : new License(this.usersLicenseFileAccessCode);
    }

    public synchronized License getNextLicenseKey(License license) throws NoMoreLicenseKeysException {
        if (this.licenses.size() == 1) {
            throw new NoMoreLicenseKeysException();
        }
        int licIx = this.licenses.indexOf(license);
        if (licIx == -1) {
            throw new IllegalArgumentException(LicenseKeyManager.buildMsg("Passed license key is not in the LicenseKeyManager's cache", license.getKey()));
        }
        if (license == this.currentLicenseKey || this.isExpired(this.currentLicenseKey)) {
            this.currentLicenseKey = this.findNextLicense(licIx, licIx + 1);
        }
        return this.currentLicenseKey;
    }

    public synchronized boolean isExpired(License license) {
        long expired = license.getTimeExpired();
        return expired != 0L && System.currentTimeMillis() < expired + this.expirationPeriod;
    }

    public synchronized boolean isUserLicensed() {
        return this.licenseFileAccessCode.equals(this.usersLicenseFileAccessCode);
    }

    public synchronized void setUsersLicenseFileAccessCode(String usersLicenseFileAccessCode) {
        this.usersLicenseFileAccessCode = usersLicenseFileAccessCode;
    }

    public synchronized void expire(License license) {
        license.setTimeExpired(System.currentTimeMillis());
        this.storeExpiredLicenseKeys(this.licenses, this.licenseExpirationFile);
    }

    public long getExpirationPeriod() {
        return this.expirationPeriod;
    }

    public synchronized void setExpirationPeriod(long expirationPeriod) {
        this.expirationPeriod = expirationPeriod;
    }

    public synchronized int getLicenseCount() {
        return this.licenses.size();
    }

    public synchronized long getTimeExpirationElapses() {
        long expirationTime = Long.MAX_VALUE;
        for (int i = this.licenses.size() - 1; i >= 0; --i) {
            License lic = (License)this.licenses.get(i);
            if (!this.isExpired(lic)) {
                return 0L;
            }
            long exp = lic.getTimeExpired();
            if (exp >= expirationTime) continue;
            expirationTime = exp;
        }
        return expirationTime + this.expirationPeriod;
    }

    private License findNextLicense(int cur, int next) throws NoMoreLicenseKeysException {
        if (cur == next) {
            throw new NoMoreLicenseKeysException();
        }
        if (next >= this.licenses.size()) {
            return this.findNextLicense(cur, 0);
        }
        License license = (License)this.licenses.get(next);
        if (this.isExpired(license)) {
            return this.findNextLicense(cur, ++next);
        }
        return license;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Map loadExpiredLicenseKeys(File file) {
        Map fileDataMap;
        block16: {
            ObjectInputStream ois;
            block15: {
                ois = null;
                fileDataMap = Collections.EMPTY_MAP;
                ois = new ObjectInputStream(new FileInputStream(file));
                Object data = ois.readObject();
                if (data instanceof Map) {
                    fileDataMap = (Map)data;
                    break block15;
                }
                StringBuffer sb = new StringBuffer();
                LicenseKeyManager.appendValue(sb, "Invalid key file", file);
                LicenseKeyManager.appendValue(sb, "Invalid data type. Expected", Map.class.getName());
                LicenseKeyManager.appendValue(sb, ", Got", data.getClass().getName());
                sb.append(" File will be recreated.");
                logger.warning(sb.toString());
            }
            Object var6_7 = null;
            try {
                if (ois != null) {
                    ois.close();
                }
                break block16;
            }
            catch (Exception e2) {}
            break block16;
            {
                catch (FileNotFoundException fnfe) {
                    Object var6_8 = null;
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                        break block16;
                    }
                    catch (Exception e2) {}
                    break block16;
                }
                catch (Throwable e) {
                    logger.severe(LicenseKeyManager.buildMsg("Cannot read license expiration data from disk file", file) + " : " + e);
                    Object var6_9 = null;
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                        break block16;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return fileDataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void storeExpiredLicenseKeys(List licKeys, File file) {
        block13: {
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (int i = 0; i < licKeys.size(); ++i) {
                License license = (License)licKeys.get(i);
                if (!this.isExpired(license)) continue;
                map.put(license.getKey(), new Long(license.getTimeExpired()));
            }
            if (!map.isEmpty()) {
                ObjectOutputStream oos = null;
                oos = new ObjectOutputStream(new FileOutputStream(file));
                oos.writeObject(map);
                Object var7_8 = null;
                try {
                    if (oos != null) {
                        oos.close();
                    }
                    break block13;
                }
                catch (Exception e2) {}
                break block13;
                {
                    catch (Throwable e) {
                        logger.severe(LicenseKeyManager.buildMsg("Cannot save license expiration data to disk file", file) + " : " + e);
                        Object var7_9 = null;
                        try {
                            if (oos != null) {
                                oos.close();
                            }
                            break block13;
                        }
                        catch (Exception e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List readLicenseKeyFile(File keyFile) {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new FileReader(keyFile));
                String line = null;
                while ((line = in.readLine()) != null) {
                    String license = line.trim();
                    if (license.length() <= 0) continue;
                    list.add(license);
                }
                Object var6_6 = null;
            }
            catch (Throwable e) {
                throw new LicenseKeyFileException(LicenseKeyManager.buildMsg("Error accessing Google license key file", keyFile), e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        if (in != null) {
            in.close();
        }
        if (!list.isEmpty()) return list;
        throw new LicenseKeyFileException(LicenseKeyManager.buildMsg("Google license key file is empty", keyFile));
    }

    private static String buildMsg(String description, Object value) {
        StringBuffer sb = new StringBuffer();
        LicenseKeyManager.appendValue(sb, description, value);
        return sb.toString();
    }

    private static void appendValue(StringBuffer sb, String description, Object value) {
        sb.append(description).append("=<").append(value).append('>');
    }

    static {
        $assertionsDisabled = !LicenseKeyManager.class.desiredAssertionStatus();
        logger = MalletLogger.getLogger(LicenseKeyManager.class.getName());
        ZERO_VALUE_LONG = new Long(0L);
    }

    public static class License {
        private String key;
        private long timeExpired;

        private License(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        private long getTimeExpired() {
            return this.timeExpired;
        }

        private void setTimeExpired(long timeExpired) {
            this.timeExpired = timeExpired;
        }
    }

    public static class NoMoreLicenseKeysException
    extends LicenseKeyFileException {
    }

    public static class LicenseKeyFileException
    extends RuntimeException {
        public LicenseKeyFileException() {
        }

        public LicenseKeyFileException(String message) {
            super(message);
        }

        public LicenseKeyFileException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

