/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import salvo.jesus.graph.visual.GraphPanel;
import salvo.jesus.graph.visual.GraphPanelState;
import salvo.jesus.graph.visual.VisualEdge;
import salvo.jesus.graph.visual.VisualGraphComponentPropertiesDialog;
import salvo.jesus.graph.visual.VisualVertex;

public class GraphPanelNormalState
extends GraphPanelState {
    VisualVertex targetvertex;
    VisualEdge targetedge;
    Cursor previouscursor;
    Cursor movecursor = new Cursor(13);
    int previous_x;
    int previous_y;

    public GraphPanelNormalState(GraphPanel gpanel) {
        super(gpanel);
    }

    public GraphPanelNormalState() {
        this(null);
    }

    public GraphPanelState mousePressed(MouseEvent e) {
        this.previous_x = e.getX();
        this.previous_y = e.getY();
        this.targetvertex = this.gpanel.getVisualGraph().getNode(this.previous_x, this.previous_y);
        this.targetedge = this.gpanel.getVisualGraph().getVisualEdge(this.previous_x, this.previous_y);
        if (e.isPopupTrigger() && (this.targetvertex != null || this.targetedge != null)) {
            this.popup(this.previous_x, this.previous_y);
        }
        this.informTargetVisualGraphComponentOfMouseEvent(e);
        return this;
    }

    public GraphPanelState mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() && (this.targetvertex != null || this.targetedge != null)) {
            this.popup(e.getX(), e.getY());
        }
        this.informTargetVisualGraphComponentOfMouseEvent(e);
        this.targetvertex = null;
        this.targetedge = null;
        this.previous_x = e.getX();
        this.previous_y = e.getY();
        return this;
    }

    public GraphPanelState mouseDragged(MouseEvent e) {
        if (this.targetvertex != null) {
            this.dragVertex(e.getX(), e.getY());
        }
        this.informTargetVisualGraphComponentOfMouseEvent(e);
        return this;
    }

    private void dragVertex(int x, int y) {
        Rectangle vertexrect = this.targetvertex.getBounds();
        int deltax = vertexrect.x + x - this.previous_x < 0 ? -vertexrect.x : x - this.previous_x;
        int deltay = vertexrect.y + y - this.previous_y < 0 ? -vertexrect.y : y - this.previous_y;
        this.targetvertex.setLocationDelta(deltax, deltay);
        this.previous_x += deltax;
        this.previous_y += deltay;
        this.gpanel.vgraph.repaint();
    }

    private void popup(int x, int y) {
        if (this.targetvertex != null) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem propertiesmenuitem = new JMenuItem("Vertex Properties...");
            JMenuItem deletemenuitem = new JMenuItem("Delete Vertex");
            popup.add(propertiesmenuitem);
            popup.addSeparator();
            popup.add(deletemenuitem);
            propertiesmenuitem.addActionListener(new ActionListener(){
                VisualVertex selectedvertex;
                {
                    this.selectedvertex = GraphPanelNormalState.this.targetvertex;
                }

                public void actionPerformed(ActionEvent actionevent) {
                    new VisualGraphComponentPropertiesDialog(GraphPanelNormalState.this.gpanel, this.selectedvertex);
                    GraphPanelNormalState.this.gpanel.repaint();
                }
            });
            deletemenuitem.addActionListener(new ActionListener(){
                VisualVertex nodetoremove;
                {
                    this.nodetoremove = GraphPanelNormalState.this.targetvertex;
                }

                public void actionPerformed(ActionEvent actionevent) {
                    if (this.nodetoremove != null) {
                        try {
                            GraphPanelNormalState.this.gpanel.getVisualGraph().remove(this.nodetoremove);
                            GraphPanelNormalState.this.gpanel.repaint();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            return;
                        }
                    }
                }
            });
            popup.show(this.gpanel, x, y);
        } else if (this.targetedge != null) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem propertiesmenuitem = new JMenuItem("Edge Properties...");
            JMenuItem deletemenuitem = new JMenuItem("Delete Edge");
            popup.add(propertiesmenuitem);
            popup.addSeparator();
            popup.add(deletemenuitem);
            propertiesmenuitem.addActionListener(new ActionListener(){
                VisualEdge selectededge;
                {
                    this.selectededge = GraphPanelNormalState.this.targetedge;
                }

                public void actionPerformed(ActionEvent actionevent) {
                    new VisualGraphComponentPropertiesDialog(GraphPanelNormalState.this.gpanel, this.selectededge);
                    GraphPanelNormalState.this.gpanel.repaint();
                }
            });
            deletemenuitem.addActionListener(new ActionListener(){
                VisualEdge edgetoremove;
                {
                    this.edgetoremove = GraphPanelNormalState.this.targetedge;
                }

                public void actionPerformed(ActionEvent actionevent) {
                    if (this.edgetoremove != null) {
                        try {
                            GraphPanelNormalState.this.gpanel.getVisualGraph().removeEdge(this.edgetoremove);
                            GraphPanelNormalState.this.gpanel.repaint();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            return;
                        }
                    }
                }
            });
            popup.show(this.gpanel, x, y);
        }
    }

    public GraphPanelState mouseMoved(MouseEvent e) {
        VisualVertex vVertex = this.gpanel.getVisualGraph().getNode(e.getX(), e.getY());
        VisualEdge vEdge = this.gpanel.getVisualGraph().getVisualEdge(e.getX(), e.getY());
        if (vVertex != null) {
            if (this.previouscursor == null) {
                this.previouscursor = this.gpanel.getCursor();
            }
            this.gpanel.setCursor(this.movecursor);
        } else {
            this.gpanel.setCursor(this.previouscursor);
            this.previouscursor = null;
        }
        this.informTargetVisualGraphComponentOfMouseEvent(e);
        return this;
    }

    public void paint(Graphics2D g2d) {
        this.gpanel.getVisualGraph().paint(g2d, this.targetvertex);
    }
}

