/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.secondstring;

import com.wcohen.secondstring.BagOfTokens;
import com.wcohen.secondstring.JaroWinkler;
import com.wcohen.secondstring.PrintfFormat;
import com.wcohen.secondstring.StringDistance;
import com.wcohen.secondstring.StringWrapper;
import com.wcohen.secondstring.TFIDF;
import com.wcohen.secondstring.tokens.Token;
import com.wcohen.secondstring.tokens.Tokenizer;
import java.util.Iterator;

public class SoftTFIDF
extends TFIDF {
    private StringDistance tokenDistance;
    private double tokenMatchThreshold;
    private static final StringDistance DEFAULT_TOKEN_DISTANCE = new JaroWinkler();

    public SoftTFIDF(Tokenizer tokenizer, StringDistance tokenDistance, double tokenMatchThreshold) {
        super(tokenizer);
        this.tokenDistance = tokenDistance;
        this.tokenMatchThreshold = tokenMatchThreshold;
    }

    public SoftTFIDF(StringDistance tokenDistance, double tokenMatchThreshold) {
        this.tokenDistance = tokenDistance;
        this.tokenMatchThreshold = tokenMatchThreshold;
    }

    public SoftTFIDF(StringDistance tokenDistance) {
        this(tokenDistance, 0.9);
    }

    public void setTokenMatchThreshold(double d) {
        this.tokenMatchThreshold = d;
    }

    public void setTokenMatchThreshold(Double d) {
        this.tokenMatchThreshold = d;
    }

    public double getTokenMatchThreshold() {
        return this.tokenMatchThreshold;
    }

    public double score(StringWrapper s, StringWrapper t) {
        BagOfTokens sBag = (BagOfTokens)s;
        BagOfTokens tBag = (BagOfTokens)t;
        double sim = 0.0;
        Iterator i = sBag.tokenIterator();
        while (i.hasNext()) {
            Token tok = (Token)i.next();
            if (tBag.contains(tok)) {
                sim += sBag.getWeight(tok) * tBag.getWeight(tok);
                continue;
            }
            double matchScore = this.tokenMatchThreshold;
            Token matchTok = null;
            Iterator j = tBag.tokenIterator();
            while (j.hasNext()) {
                Token tokJ = (Token)j.next();
                double distItoJ = this.tokenDistance.score(tok.getValue(), tokJ.getValue());
                if (!(distItoJ >= matchScore)) continue;
                matchTok = tokJ;
                matchScore = distItoJ;
            }
            if (matchTok == null) continue;
            sim += sBag.getWeight(tok) * tBag.getWeight(matchTok) * matchScore;
        }
        return sim;
    }

    public String explainScore(StringWrapper s, StringWrapper t) {
        BagOfTokens sBag = (BagOfTokens)s;
        BagOfTokens tBag = (BagOfTokens)t;
        StringBuffer buf = new StringBuffer("");
        PrintfFormat fmt = new PrintfFormat("%.3f");
        buf.append("Common tokens: ");
        Iterator i = sBag.tokenIterator();
        while (i.hasNext()) {
            Token tok = (Token)i.next();
            if (tBag.contains(tok)) {
                buf.append(" " + tok.getValue() + ": ");
                buf.append(fmt.sprintf(sBag.getWeight(tok)));
                buf.append("*");
                buf.append(fmt.sprintf(tBag.getWeight(tok)));
                continue;
            }
            double matchScore = this.tokenMatchThreshold;
            Token matchTok = null;
            Iterator j = tBag.tokenIterator();
            while (j.hasNext()) {
                Token tokJ = (Token)j.next();
                double distItoJ = this.tokenDistance.score(tok.getValue(), tokJ.getValue());
                if (!(distItoJ >= matchScore)) continue;
                matchTok = tokJ;
                matchScore = distItoJ;
            }
            if (matchTok == null) continue;
            buf.append(" '" + tok.getValue() + "'~='" + matchTok.getValue() + "': ");
            buf.append(fmt.sprintf(sBag.getWeight(tok)));
            buf.append("*");
            buf.append(fmt.sprintf(tBag.getWeight(matchTok)));
            buf.append("*");
            buf.append(fmt.sprintf(matchScore));
        }
        buf.append("\nscore = " + this.score(s, t));
        return buf.toString();
    }

    public String toString() {
        return "[SoftTFIDF thresh=" + this.tokenMatchThreshold + ";" + this.tokenDistance + "]";
    }
}

