/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.dex.graph;

import edu.umass.cs.dex.DexRuntimeException;
import edu.umass.cs.dex.types.People;
import edu.umass.cs.dex.types.Person;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.EdgeImpl;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.VertexImpl;
import salvo.jesus.graph.WeightedEdgeImpl;
import salvo.jesus.graph.WeightedGraph;
import salvo.jesus.graph.WeightedGraphImpl;
import salvo.jesus.graph.algorithm.ShortestPathDijkstraAlgorithm;
import salvo.jesus.util.HeapNodeComparator;

public class PeopleGraph
extends WeightedGraphImpl {
    private static Logger logger = MalletLogger.getLogger(PeopleGraph.class.getName());
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public PeopleGraph(People people) {
        this(people, false);
    }

    public PeopleGraph(People people, boolean useEmailLinks) {
        try {
            HashMap<Person, VertexImpl> person2vertex = new HashMap<Person, VertexImpl>(people.size());
            logger.info("Adding " + people.size() + " nodes to social network.");
            Iterator keyIter = people.getMap().keySet().iterator();
            while (keyIter.hasNext()) {
                Integer id = (Integer)keyIter.next();
                Person p = (Person)people.getMap().get(id);
                VertexImpl v = (VertexImpl)person2vertex.get(p);
                if (v == null) {
                    v = new VertexImpl((Object)p);
                    v.setLabel(String.valueOf(p.getId()));
                    this.add((Vertex)v);
                    person2vertex.put(p, v);
                }
                Iterator pIter = p.outLinks.iterator();
                while (pIter.hasNext()) {
                    WeightedEdgeImpl e;
                    Person neighbor = people.getPerson((Integer)pIter.next());
                    if (p.equals(neighbor)) {
                        logger.fine("Skipping self edge for " + p);
                        continue;
                    }
                    VertexImpl neighborVertex = (VertexImpl)person2vertex.get(neighbor);
                    if (neighborVertex == null) {
                        neighborVertex = new VertexImpl((Object)neighbor);
                        neighborVertex.setLabel(String.valueOf(neighbor.getId()));
                        this.add((Vertex)neighborVertex);
                        person2vertex.put(neighbor, neighborVertex);
                    }
                    if (useEmailLinks) {
                        this.addEdge((Vertex)v, (Vertex)neighborVertex, 1.0);
                        continue;
                    }
                    if (p.keyWords.numLocations() == 0 || neighbor.keyWords.numLocations() == 0) {
                        e = new WeightedEdgeImpl((Vertex)v, (Vertex)neighborVertex, 1.0);
                        if (this.isConnected((Vertex)v, (Vertex)neighborVertex)) continue;
                        this.addEdge((Edge)e);
                        continue;
                    }
                    e = new WeightedEdgeImpl((Vertex)v, (Vertex)neighborVertex, 1.0);
                    if (this.isConnected((Vertex)v, (Vertex)neighborVertex)) continue;
                    this.addEdge((Vertex)v, (Vertex)neighborVertex, 1.0);
                }
                if (!useEmailLinks) continue;
                Iterator lIter = p.emailLinks.keySet().iterator();
                while (lIter.hasNext()) {
                    String name = (String)lIter.next();
                    int pid = people.findPersonByName(name);
                    Person emailNeighbor = people.getPerson(pid);
                    if (p.equals(emailNeighbor)) {
                        logger.fine("Skipping self edge");
                        continue;
                    }
                    if (pid == -1) {
                        logger.warning("person " + name + " not in people object");
                        continue;
                    }
                    VertexImpl emailNeighborVertex = (VertexImpl)person2vertex.get(emailNeighbor);
                    if (emailNeighborVertex == null) {
                        emailNeighborVertex = new VertexImpl((Object)emailNeighbor);
                        emailNeighborVertex.setLabel(String.valueOf(emailNeighbor.getId()));
                        this.add((Vertex)emailNeighborVertex);
                        person2vertex.put(emailNeighbor, emailNeighborVertex);
                    }
                    logger.fine("adding edge with weight " + p.emailLinks.get(name));
                    this.addEdge((Vertex)v, (Vertex)emailNeighborVertex, 1.0);
                }
            }
            logger.info(this.getEdgesCount() + " edges added to social network.");
            Vertex[] vs = this.getVertices(0).toArray(new Vertex[0]);
            for (int i = 0; i < vs.length; ++i) {
                this.remove(vs[i]);
            }
        }
        catch (Exception e) {
            String msg = "Error constructing graph: ";
            logger.severe(msg);
            throw new DexRuntimeException(msg, e);
        }
    }

    private String getName(VertexImpl v) {
        String name = "";
        Person p = (Person)v.getObject();
        return p.getFirstName() == null ? v.toString() : p.getFirstName();
    }

    public void printZoomGraphFile(File f) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            out.write("nodedef> name VARCHAR(256)\n");
            Iterator viter = this.getVerticesIterator();
            while (viter.hasNext()) {
                VertexImpl v = (VertexImpl)viter.next();
                out.write(this.getName(v) + "\n");
            }
            out.write("edgedef> n1 VARCHAR(256),n2 VARCHAR(256)\n");
            Iterator eiter = this.getEdgeSet().iterator();
            while (eiter.hasNext()) {
                Edge e = (Edge)eiter.next();
                out.write(this.getName((VertexImpl)e.getVertexA()) + "," + this.getName((VertexImpl)e.getVertexB()) + "\n");
            }
            out.close();
        }
        catch (IOException e) {
            String msg = "Exception printing zoom graph";
            logger.severe(msg + ": " + e);
            throw new DexRuntimeException(msg, e);
        }
    }

    public void printAllStatistics(File zoomFile) {
        this.printAllStatistics(true, zoomFile);
    }

    public void printAllStatistics(boolean cluster, File zoomFile) {
        try {
            logger.info("Printing All Statistics");
            logger.info("ORDERED BY DEGREE:");
            this.printPeopleByDegree();
            logger.info("DEGREE DISTRIBUTION:");
            this.printDegreeDistribution();
            this.printConnectedComponentsStatistics();
            logger.info("GRAPH DEGREE: " + this.getDegree());
            logger.info("NUMBER VERTICES: " + this.getVerticesCount());
            logger.info("NUMBER EDGES: " + this.getEdgesCount());
            HashMap between = this.getBetweennessOfEdges();
            this.printTopNBetweennessNodes(10, between);
            if (cluster) {
                logger.info("Begin clustering social network.");
                this.clusterByBetweenness(between);
            }
            this.printConnectedComponentsStatistics();
            this.printConnectedComponents();
            this.printZoomGraphFile(zoomFile);
        }
        catch (Exception e) {
            String msg = "Exception printing graph statistics: ";
            logger.severe(msg + ": " + e);
            throw new DexRuntimeException(msg, e);
        }
    }

    public void writeGraph(File f) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject((Object)this);
        }
        catch (IOException e) {
            String msg = "Could not write graph to file " + f + ": ";
            logger.severe(msg + ": " + e);
            throw new DexRuntimeException(msg, e);
        }
    }

    public void clusterByBetweenness() throws Exception {
        this.clusterByBetweenness(this.getBetweennessOfEdges());
    }

    public void clusterByBetweenness(HashMap betweenness) throws Exception {
        boolean found;
        TreeMap rankedEdges = null;
        Vector highestEdges = null;
        Edge highestEdge = null;
        Integer[] keys = null;
        do {
            rankedEdges = this.sortEdgesByBetweenness(betweenness);
            keys = new Integer[rankedEdges.size()];
            keys = rankedEdges.keySet().toArray(keys);
            found = false;
            for (int i = keys.length - 1; i >= 0 && !found; --i) {
                highestEdges = (Vector)rankedEdges.get(keys[i]);
                for (int j = 0; j < highestEdges.size() && !found; ++j) {
                    highestEdge = (Edge)highestEdges.get(j);
                    if (!this.canRemoveEdge(highestEdge, betweenness)) continue;
                    logger.info("Removing Edge: " + highestEdge);
                    Set edgeSet = this.getEdgeSet();
                    this.removeEdge(highestEdge);
                    betweenness = this.getBetweennessOfEdges();
                    found = true;
                }
            }
        } while (found);
        logger.info("No more valid edges to remove. Clustering complete.");
        logger.info("-----------------------------\n\nPrinting Cluster Information");
    }

    private boolean canRemoveEdge(Edge e, HashMap betweenness) {
        Set component = this.getConnectedSet(e.getVertexA());
        return component.size() >= 6 && this.highestBetweenness(component, betweenness) > component.size() - 1;
    }

    private int highestBetweenness(Set vertices, HashMap betweenness) {
        TreeMap sortedEdges = new TreeMap();
        Iterator viter = vertices.iterator();
        while (viter.hasNext()) {
            Vertex v = (Vertex)viter.next();
            Iterator eiter = this.getEdges(v).iterator();
            while (eiter.hasNext()) {
                Edge e = (Edge)eiter.next();
                sortedEdges.put(betweenness.get(e.toString()), e);
            }
        }
        return (Integer)sortedEdges.lastKey();
    }

    public void printTopNBetweennessNodes(int n, HashMap betweenness) {
        if (n > this.getVerticesCount()) {
            n = this.getVerticesCount();
        }
        TreeMap rankedPeople = this.sortPeopleByBetweenness(betweenness);
        Iterator miter = rankedPeople.keySet().iterator();
        int nprinted = 0;
        while (miter.hasNext() && nprinted < n) {
            Integer key = (Integer)miter.next();
            Vector peeps = (Vector)rankedPeople.get(key);
            logger.info("Betweeness=" + key);
            for (int pi = 0; pi < peeps.size() && nprinted <= n; ++pi) {
                Person p = (Person)peeps.get(pi);
                logger.info(p.toString());
            }
        }
    }

    public void printConnectedComponents() {
        this.forgetConnectedSets();
        Iterator iter = this.getConnectedSet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Set set = (Set)iter.next();
            if (set.size() > 1) {
                logger.info("Cluster " + i + ": [");
                Iterator viter = set.iterator();
                while (viter.hasNext()) {
                    VertexImpl v = (VertexImpl)viter.next();
                    Person p = (Person)v.getObject();
                    logger.info(p.toString() + ",");
                }
                logger.info("]");
            }
            ++i;
        }
    }

    public void printConnectedComponentsStatistics() {
        this.forgetConnectedSets();
        ArrayList components = new ArrayList(this.getConnectedSet());
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < components.size(); ++i) {
            int size = ((Set)components.get(i)).size();
            if (size <= 1) continue;
            logger.info("Cluster " + i + " has " + size + " vertices");
            ++count;
            sum += (double)size;
        }
        logger.info("Number Clusters: " + count);
        logger.info("Average cluster size: " + sum / (double)count);
    }

    public TreeMap sortPeopleByBetweenness(HashMap edgeHash) {
        TreeMap<Integer, Vector<Person>> personMap = new TreeMap<Integer, Vector<Person>>();
        Iterator viter = this.getVerticesIterator();
        while (viter.hasNext()) {
            VertexImpl v = (VertexImpl)viter.next();
            int totalBetweenness = 0;
            List edges = this.getEdges((Vertex)v);
            for (int i = 0; i < edges.size(); ++i) {
                Integer bt = (Integer)edgeHash.get(((EdgeImpl)edges.get(i)).toString());
                totalBetweenness += bt == null ? 0 : bt;
            }
            Integer key = new Integer(totalBetweenness);
            Vector<Person> peeps = (Vector<Person>)personMap.get(key);
            if (peeps == null) {
                peeps = new Vector<Person>();
            }
            peeps.add((Person)v.getObject());
            personMap.put(key, peeps);
        }
        return personMap;
    }

    public TreeMap sortEdgesByBetweenness(HashMap edgeHash) {
        TreeMap<Integer, Vector<Edge>> edgeMap = new TreeMap<Integer, Vector<Edge>>();
        Iterator eiter = this.getEdgeSet().iterator();
        while (eiter.hasNext()) {
            Edge e = (Edge)eiter.next();
            Integer key = (Integer)edgeHash.get(e.toString());
            if (key == null) {
                String eid = e.toString();
                String[] verts = eid.split("-");
                if (verts.length != 2) {
                    throw new IllegalArgumentException("Invalid Edge ID: " + eid);
                }
                key = (Integer)edgeHash.get(verts[1] + "-" + verts[0]);
            }
            if (key == null) {
                throw new IllegalArgumentException("edge " + e + " not in edgeHash");
            }
            Vector<Edge> storedEdges = (Vector<Edge>)edgeMap.get(key);
            if (storedEdges == null) {
                storedEdges = new Vector<Edge>();
            }
            storedEdges.add(e);
            edgeMap.put(key, storedEdges);
        }
        return edgeMap;
    }

    private HashMap initBetweennessHash() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>(this.getEdgeSet().size());
        Iterator iter = this.getEdgeSet().iterator();
        while (iter.hasNext()) {
            EdgeImpl e = (EdgeImpl)iter.next();
            ret.put(e.toString(), new Integer(0));
        }
        return ret;
    }

    public HashMap getBetweennessOfEdges() {
        HashMap hash = this.initBetweennessHash();
        Iterator viter = this.getVerticesIterator();
        ShortestPathDijkstraAlgorithm dijkstra = new ShortestPathDijkstraAlgorithm((WeightedGraph)this, new HeapNodeComparator(0));
        boolean vi = false;
        while (viter.hasNext()) {
            Vertex v = (Vertex)viter.next();
            WeightedGraph paths = dijkstra.shortestPath(v);
            if (paths == null || paths.getVerticesCount() == 0) continue;
            this.depthFirstCountBetweenness(new Stack(), v, null, hash, paths);
        }
        this.divideBy(hash, 2);
        return hash;
    }

    private void divideBy(HashMap hash, int q) {
        Iterator iter = hash.keySet().iterator();
        while (iter.hasNext()) {
            String e = (String)iter.next();
            int count = (Integer)hash.get(e);
            hash.put(e.toString(), new Integer(count / 2));
        }
    }

    private void depthFirstCountBetweenness(Stack edges, Vertex v, Vertex source, HashMap edgeCounts, WeightedGraph graph) {
        List nextEdges = graph.getEdges(v);
        if (nextEdges == null) {
            return;
        }
        for (int i = 0; i < nextEdges.size(); ++i) {
            EdgeImpl e = (EdgeImpl)nextEdges.get(i);
            Vertex nextVertex = e.getOppositeVertex(v);
            if (source != null && nextVertex.equals(source)) continue;
            edges.push(e);
            this.incrementBetweenness(edges, edgeCounts);
            this.depthFirstCountBetweenness(edges, nextVertex, v, edgeCounts, graph);
            edges.pop();
        }
    }

    private void incrementBetweenness(Stack edges, HashMap edgeCounts) {
        Iterator iter = edges.iterator();
        while (iter.hasNext()) {
            EdgeImpl e = (EdgeImpl)iter.next();
            Integer count = (Integer)edgeCounts.get(e.toString());
            if (count == null) {
                count = new Integer(0);
            }
            edgeCounts.put(e.toString(), new Integer(count + 1));
        }
    }

    public TreeMap sortPeopleByDegree() {
        TreeMap<Integer, Vector<Person>> map = new TreeMap<Integer, Vector<Person>>();
        Iterator viter = this.getVerticesIterator();
        while (viter.hasNext()) {
            VertexImpl v = (VertexImpl)viter.next();
            Integer key = new Integer(this.getEdges((Vertex)v).size());
            Vector<Person> peeps = (Vector<Person>)map.get(key);
            if (peeps == null) {
                peeps = new Vector<Person>();
            }
            peeps.add((Person)v.getObject());
            map.put(key, peeps);
        }
        return map;
    }

    public void printDegreeDistribution() {
        TreeMap map = this.sortPeopleByDegree();
        Iterator miter = map.keySet().iterator();
        while (miter.hasNext()) {
            Integer key = (Integer)miter.next();
            logger.info("DEGREE " + key + ": " + ((Vector)map.get(key)).size());
        }
    }

    public void printPeopleByDegree() {
        TreeMap map = this.sortPeopleByDegree();
        Iterator miter = map.keySet().iterator();
        while (miter.hasNext()) {
            Integer key = (Integer)miter.next();
            logger.info("DEGREE " + key);
            Vector peeps = (Vector)map.get(key);
            for (int pi = 0; pi < peeps.size(); ++pi) {
                Person p = (Person)peeps.get(pi);
                logger.info(p.toString());
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
    }
}

