/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.dex.web;

import edu.umass.cs.dex.types.People;
import edu.umass.cs.dex.types.Person;
import edu.umass.cs.dex.web.Google;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.io.File;
import java.util.HashSet;
import java.util.Vector;
import java.util.logging.Logger;

public class WebThread
extends Thread {
    private static Logger logger = MalletLogger.getLogger(WebThread.class.getName());
    Vector queries;
    String outDirName;
    Person person;
    HashSet stopWords;
    Vector googleKeys;
    int maxUrls;
    People people;
    File peopleFile;
    private Throwable exception;

    public WebThread(Vector queries, String outDirName, Person person, HashSet stopWords, int maxUrls, People people, File peopleFile) {
        this.queries = queries;
        this.outDirName = outDirName;
        this.person = person;
        this.stopWords = stopWords;
        this.maxUrls = maxUrls;
        this.people = people;
        this.peopleFile = peopleFile;
    }

    public void run() {
        try {
            this.process();
        }
        catch (Throwable e) {
            this.exception = e;
        }
    }

    private void process() {
        Google google = new Google(this.getName(), this.outDirName, this.person, this.stopWords, this.maxUrls, this.people, this.peopleFile);
        for (int j = 0; j < this.queries.size(); ++j) {
            String query = (String)this.queries.elementAt(j);
            logger.fine(this.getName() + ") Processing query: " + query);
            boolean response = google.responseToQuery(query);
            if (response) break;
        }
        logger.fine("Thread " + this.getName() + " is about to finish");
    }

    public Throwable getException() {
        return this.exception;
    }
}

