/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.util.Iterator;
import no.uib.cipr.matrix.AbstractVector;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseVector
extends AbstractVector {
    double[] data;
    int[] index;
    int used;

    public SparseVector(int size, int nz) {
        super(size);
        this.data = new double[nz];
        this.index = new int[nz];
    }

    public SparseVector(Vector x, boolean deep) {
        super(x);
        if (deep) {
            int nz = Matrices.cardinality(x);
            this.data = new double[nz];
            this.index = new int[nz];
            this.set(x);
        } else {
            SparseVector xs = (SparseVector)x;
            this.data = xs.getData();
            this.index = xs.getIndex();
            this.used = xs.getUsed();
        }
    }

    public SparseVector(Vector x) {
        this(x, true);
    }

    public SparseVector(int size) {
        this(size, 0);
    }

    public SparseVector(int size, int[] index, double[] data, boolean deep) {
        super(size);
        if (index.length != data.length) {
            throw new IllegalArgumentException("index.length != data.length");
        }
        if (deep) {
            this.used = index.length;
            this.index = (int[])index.clone();
            this.data = (double[])data.clone();
        } else {
            this.index = index;
            this.data = data;
            this.used = index.length;
        }
    }

    public SparseVector(int size, int[] index, double[] data) {
        this(size, index, data, true);
    }

    @Override
    public void set(int index, double value) {
        this.check(index);
        int i = this.getIndex(index);
        this.data[i] = value;
    }

    @Override
    public void add(int index, double value) {
        int i;
        this.check(index);
        int n = i = this.getIndex(index);
        this.data[n] = this.data[n] + value;
    }

    @Override
    public double get(int index) {
        this.check(index);
        int in = Arrays.binarySearch(this.index, index, 0, this.used);
        if (in >= 0) {
            return this.data[in];
        }
        return 0.0;
    }

    private int getIndex(int ind) {
        int i = Arrays.binarySearchGreater(this.index, ind, 0, this.used);
        if (i < this.used && this.index[i] == ind) {
            return i;
        }
        int[] newIndex = this.index;
        double[] newData = this.data;
        if (++this.used > this.data.length) {
            int newLength = this.data.length != 0 ? this.data.length << 1 : 1;
            newIndex = new int[newLength];
            newData = new double[newLength];
            System.arraycopy(this.index, 0, newIndex, 0, i);
            System.arraycopy(this.data, 0, newData, 0, i);
        }
        System.arraycopy(this.index, i, newIndex, i + 1, this.used - i - 1);
        System.arraycopy(this.data, i, newData, i + 1, this.used - i - 1);
        newIndex[i] = ind;
        newData[i] = 0.0;
        this.index = newIndex;
        this.data = newData;
        return i;
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(this);
    }

    @Override
    public SparseVector zero() {
        java.util.Arrays.fill(this.data, 0.0);
        return this;
    }

    @Override
    public SparseVector scale(double alpha) {
        if (alpha == 0.0) {
            return this.zero();
        }
        if (alpha == 1.0) {
            return this;
        }
        int i = 0;
        while (i < this.used) {
            int n = i++;
            this.data[n] = this.data[n] * alpha;
        }
        return this;
    }

    @Override
    public double dot(Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.dot(y);
        }
        this.checkSize(y);
        double[] yd = ((DenseVector)y).getData();
        double ret = 0.0;
        for (int i = 0; i < this.used; ++i) {
            ret += this.data[i] * yd[this.index[i]];
        }
        return ret;
    }

    @Override
    protected double norm1() {
        double sum = 0.0;
        for (int i = 0; i < this.used; ++i) {
            sum += Math.abs(this.data[i]);
        }
        return sum;
    }

    @Override
    protected double norm2() {
        double norm = 0.0;
        for (int i = 0; i < this.used; ++i) {
            norm += this.data[i] * this.data[i];
        }
        return Math.sqrt(norm);
    }

    @Override
    protected double norm2_robust() {
        double scale = 0.0;
        double ssq = 1.0;
        for (int i = 0; i < this.used; ++i) {
            if (this.data[i] == 0.0) continue;
            double absxi = Math.abs(this.data[i]);
            if (scale < absxi) {
                ssq = 1.0 + ssq * Math.pow(scale / absxi, 2.0);
                scale = absxi;
                continue;
            }
            ssq += Math.pow(absxi / scale, 2.0);
        }
        return scale * Math.sqrt(ssq);
    }

    @Override
    protected double normInf() {
        double max = 0.0;
        for (int i = 0; i < this.used; ++i) {
            max = Math.max(Math.abs(this.data[i]), max);
        }
        return max;
    }

    public double[] getData() {
        return this.data;
    }

    public int[] getIndex() {
        return this.index;
    }

    public int getUsed() {
        return this.used;
    }

    public void compact() {
        int nz = Matrices.cardinality(this);
        if (nz < this.data.length) {
            int[] newIndex = new int[nz];
            double[] newData = new double[nz];
            int j = 0;
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == 0.0) continue;
                newIndex[j] = this.index[i];
                newData[j] = this.data[i];
                ++j;
            }
            this.data = newData;
            this.index = newIndex;
            this.used = this.data.length;
        }
    }

    @Override
    public Iterator<VectorEntry> iterator() {
        return new SparseVectorIterator();
    }

    @Override
    public Vector set(Vector y) {
        if (!(y instanceof SparseVector)) {
            return super.set(y);
        }
        this.checkSize(y);
        SparseVector yc = (SparseVector)y;
        if (yc.index.length != this.index.length) {
            this.data = new double[yc.data.length];
            this.index = new int[yc.data.length];
        }
        System.arraycopy(yc.data, 0, this.data, 0, this.data.length);
        System.arraycopy(yc.index, 0, this.index, 0, this.index.length);
        this.used = yc.used;
        return this;
    }

    private class SparseVectorEntry
    implements VectorEntry {
        private int cursor;

        private SparseVectorEntry() {
        }

        public void update(int cursor) {
            this.cursor = cursor;
        }

        public int index() {
            return SparseVector.this.index[this.cursor];
        }

        public double get() {
            return SparseVector.this.data[this.cursor];
        }

        public void set(double value) {
            SparseVector.this.data[this.cursor] = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SparseVectorIterator
    implements Iterator<VectorEntry> {
        private int cursor;
        private final SparseVectorEntry entry;

        private SparseVectorIterator() {
            this.entry = new SparseVectorEntry();
        }

        @Override
        public boolean hasNext() {
            return this.cursor < SparseVector.this.used;
        }

        @Override
        public VectorEntry next() {
            this.entry.update(this.cursor);
            ++this.cursor;
            return this.entry;
        }

        @Override
        public void remove() {
            this.entry.set(0.0);
        }
    }
}

