/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.inference.Utils;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.DenseAssignmentIterator;
import cc.mallet.grmm.types.Universe;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;

public class BitVarSet
extends AbstractSet
implements VarSet {
    private Universe universe;
    private BitSet bitset;
    private int cachedWeight = -1;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public BitVarSet(Universe universe, BitSet included) {
        this.universe = universe;
        this.bitset = included;
    }

    public BitVarSet(Universe universe, Collection included) {
        this.universe = universe;
        this.bitset = new BitSet(universe.size());
        java.util.Iterator it = included.iterator();
        while (it.hasNext()) {
            this.bitset.set(universe.getIndex((Variable)it.next()));
        }
    }

    public BitVarSet(VarSet vsOld) {
        this(vsOld.get(0).getUniverse(), vsOld);
    }

    public boolean add(Object o) {
        int idx = this.universe.getIndex((Variable)o);
        if (idx == -1) {
            throw new UnsupportedOperationException();
        }
        this.bitset.set(idx);
        return true;
    }

    public Variable get(int idx) {
        int mapIdx = 0;
        mapIdx = this.bitset.nextSetBit(0);
        for (int i = 0; i < idx; ++i) {
            if ((mapIdx = this.bitset.nextSetBit(mapIdx + 1)) != -1) continue;
            throw new IndexOutOfBoundsException("Index " + idx + " in BitSetClique");
        }
        return this.universe.get(mapIdx);
    }

    public Variable[] toVariableArray() {
        return this.toArray(new Variable[0]);
    }

    public int weight() {
        if (this.cachedWeight == -1) {
            int weight = 1;
            Iterator it = new Iterator();
            while (it.hasNext()) {
                Variable var = (Variable)it.next();
                weight *= var.getNumOutcomes();
            }
            this.cachedWeight = weight;
        }
        return this.cachedWeight;
    }

    public AssignmentIterator assignmentIterator() {
        return new DenseAssignmentIterator(this);
    }

    public int size() {
        return this.bitset.cardinality();
    }

    public boolean isEmpty() {
        return this.bitset.isEmpty();
    }

    public boolean contains(Object o) {
        return this.bitset.get(this.universe.getIndex((Variable)o));
    }

    public java.util.Iterator iterator() {
        return new Iterator();
    }

    public int hashCode() {
        return this.bitset.hashCode();
    }

    public boolean containsAll(Collection c) {
        if (c instanceof BitVarSet) {
            return this.containsAll((BitVarSet)c);
        }
        return super.containsAll(c);
    }

    public boolean containsAll(BitVarSet bsc) {
        assert (this.universe == bsc.universe);
        int i = bsc.bitset.nextSetBit(0);
        while (i >= 0) {
            if (!this.bitset.get(i)) {
                return false;
            }
            i = bsc.bitset.nextSetBit(i + 1);
        }
        return true;
    }

    public VarSet intersection(VarSet c) {
        if (c instanceof BitVarSet) {
            BitVarSet bsc = (BitVarSet)c;
            BitSet newBitSet = (BitSet)this.bitset.clone();
            newBitSet.and(bsc.bitset);
            return new BitVarSet(this.universe, newBitSet);
        }
        return Utils.defaultIntersection(this, c);
    }

    public int intersectionSize(BitVarSet bsc) {
        assert (this.universe == bsc.universe);
        int size = 0;
        int i = bsc.bitset.nextSetBit(0);
        while (i >= 0) {
            if (this.bitset.get(i)) {
                ++size;
            }
            i = bsc.bitset.nextSetBit(i + 1);
        }
        return size;
    }

    public void clear() {
        this.bitset.clear();
    }

    public boolean hasLabel() {
        return true;
    }

    public String getLabel() {
        return this.toString();
    }

    public String toString() {
        String foo = "(C";
        Iterator it = new Iterator();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            foo = foo + " " + var;
        }
        foo = foo + ")";
        return foo;
    }

    public void setLabel(String s) {
        throw new UnsupportedOperationException();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
    }

    private class Iterator
    implements java.util.Iterator {
        int nextIdx;

        public Iterator() {
            this.nextIdx = BitVarSet.this.bitset.nextSetBit(0);
        }

        public boolean hasNext() {
            return this.nextIdx >= 0;
        }

        public Object next() {
            int thisIdx = this.nextIdx;
            this.nextIdx = BitVarSet.this.bitset.nextSetBit(thisIdx + 1);
            return BitVarSet.this.universe.get(thisIdx);
        }

        public void remove() {
            throw new UnsupportedOperationException("Removal from BitSetClique not permitted");
        }
    }
}

