/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.inference.ExactSampler;
import cc.mallet.grmm.inference.VariableElimination;
import cc.mallet.grmm.types.AbstractTableFactor;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.AssignmentIterator;
import cc.mallet.grmm.types.BidirectionalIntObjectMap;
import cc.mallet.grmm.types.ConstantFactor;
import cc.mallet.grmm.types.DenseAssignmentIterator;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.Factors;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.LogTableFactor;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.Universe;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.grmm.util.CSIntInt2ObjectMultiMap;
import cc.mallet.grmm.util.Models;
import cc.mallet.util.CollectionUtils;
import cc.mallet.util.Randoms;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FactorGraph
implements Factor {
    private final List factors = new ArrayList();
    private final THashMap clique2ptl = new THashMap();
    private Universe universe;
    private TIntIntHashMap projectionMap;
    private int[] my2global;
    private BidirectionalIntObjectMap factorsAlphabet;
    private transient List[] vertexPots;
    private transient CSIntInt2ObjectMultiMap pairwiseFactors;
    private transient List[] factorsByVar;
    int numNodes = 0;
    transient THashMap inferenceCaches = new THashMap();
    private static final String[] colors = new String[]{"red", "green", "blue", "yellow"};
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public FactorGraph() {
        this.setCachesCapacity(0);
        this.factorsAlphabet = new BidirectionalIntObjectMap();
    }

    public FactorGraph(Variable[] vars) {
        this();
        this.setCachesCapacity(vars.length);
        for (int i = 0; i < vars.length; ++i) {
            this.cacheVariable(vars[i]);
        }
    }

    public FactorGraph(Factor[] factors) {
        this();
        for (int i = 0; i < factors.length; ++i) {
            this.addFactor(factors[i]);
        }
    }

    public FactorGraph(Collection factors) {
        this();
        Iterator it = factors.iterator();
        while (it.hasNext()) {
            this.addFactor((Factor)it.next());
        }
    }

    public FactorGraph(int capacity) {
        this();
        this.setCachesCapacity(capacity);
    }

    private void clearCaches() {
        this.setCachesCapacity(this.numNodes);
        this.pairwiseFactors.clear();
        this.projectionMap.clear();
    }

    private void setCachesCapacity(int n) {
        this.factorsByVar = new List[n];
        for (int i = 0; i < n; ++i) {
            this.factorsByVar[i] = new ArrayList();
        }
        this.vertexPots = new List[n];
        this.my2global = new int[n];
        if (this.projectionMap == null) {
            this.projectionMap = new TIntIntHashMap(n);
        } else {
            this.projectionMap.ensureCapacity(n);
        }
        if (this.pairwiseFactors == null) {
            this.pairwiseFactors = new CSIntInt2ObjectMultiMap();
        }
    }

    private void removeFactor(Factor factor) {
        this.factors.remove(factor);
        this.clique2ptl.remove((Object)factor.varSet());
        this.regenerateCaches();
    }

    private void removeFactorsOfVariable(final Variable var) {
        Iterator it = this.factors.iterator();
        while (it.hasNext()) {
            Factor ptl = (Factor)it.next();
            if (!ptl.varSet().contains(var)) continue;
            it.remove();
        }
        this.clique2ptl.retainEntries(new TObjectObjectProcedure(){

            public boolean execute(Object clique, Object ptl) {
                return !((VarSet)clique).contains(var);
            }
        });
    }

    private void removeFromVariableCaches(Variable victim) {
        THashSet survivors = new THashSet((Collection)this.variablesSet());
        survivors.remove(victim);
        int vi = 0;
        TIntIntHashMap dict = new TIntIntHashMap(survivors.size());
        this.my2global = new int[survivors.size()];
        for (Variable var : survivors) {
            int gvi = var.getIndex();
            dict.put(gvi, vi);
            this.my2global[vi] = gvi;
        }
        this.projectionMap = dict;
        --this.numNodes;
    }

    private void recacheFactors() {
        this.numNodes = 0;
        for (Factor ptl : this.factors) {
            VarSet vs = ptl.varSet();
            this.addVarsIfNecessary(vs);
            this.cacheFactor(vs, ptl);
        }
    }

    private void regenerateCaches() {
        this.clearCaches();
        this.recacheFactors();
    }

    private void updateFactorCaches() {
        assert (this.numNodes == this.numVariables());
        if (this.vertexPots == null) {
            this.setCachesCapacity(this.numNodes);
        } else if (this.numNodes > this.vertexPots.length) {
            List[] oldVertexPots = this.vertexPots;
            CSIntInt2ObjectMultiMap oldEdgePots = this.pairwiseFactors;
            List[] oldFactorsByVar = this.factorsByVar;
            int[] oldM2G = this.my2global;
            this.setCachesCapacity(2 * this.numNodes);
            assert (oldEdgePots != null);
            System.arraycopy(oldVertexPots, 0, this.vertexPots, 0, oldVertexPots.length);
            System.arraycopy(oldM2G, 0, this.my2global, 0, oldM2G.length);
            for (int i = 0; i < oldFactorsByVar.length; ++i) {
                this.factorsByVar[i].addAll(oldFactorsByVar[i]);
            }
        }
    }

    private void cacheVariable(Variable var) {
        ++this.numNodes;
        this.updateFactorCaches();
        int gvi = var.getIndex();
        int myvi = this.numNodes - 1;
        this.projectionMap.put(gvi, myvi);
        this.my2global[myvi] = gvi;
    }

    private void cacheFactor(VarSet varSet, Factor factor) {
        switch (varSet.size()) {
            case 1: {
                int vidx = this.getIndex(varSet.get(0));
                this.cacheVariableFactor(vidx, factor);
                this.factorsByVar[vidx].add(factor);
                break;
            }
            case 2: {
                int idx1 = this.getIndex(varSet.get(0));
                int idx2 = this.getIndex(varSet.get(1));
                this.cachePairwiseFactor(idx1, idx2, factor);
                break;
            }
            default: {
                for (Variable var : varSet) {
                    int idx = this.getIndex(var);
                    this.factorsByVar[idx].add(factor);
                }
            }
        }
    }

    private void cacheVariableFactor(int vidx, Factor factor) {
        if (this.vertexPots[vidx] == null) {
            this.vertexPots[vidx] = new ArrayList(2);
        }
        this.vertexPots[vidx].add(factor);
    }

    private void cachePairwiseFactor(int idx1, int idx2, Factor ptl) {
        this.pairwiseFactors.add(idx1, idx2, ptl);
        this.pairwiseFactors.add(idx2, idx1, ptl);
        this.factorsByVar[idx1].add(ptl);
        this.factorsByVar[idx2].add(ptl);
    }

    public int numVariables() {
        return this.numNodes;
    }

    public Set variablesSet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return FactorGraph.this.variablesIterator();
            }

            public int size() {
                return FactorGraph.this.numNodes;
            }
        };
    }

    public Iterator variablesIterator() {
        return new Iterator(){
            private int i = 0;

            public boolean hasNext() {
                return this.i < FactorGraph.this.numNodes;
            }

            public Object next() {
                return FactorGraph.this.get(this.i++);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public VarSet getAdjacentVertices(Variable var) {
        HashVarSet c = new HashVarSet();
        List adjFactors = this.allFactorsContaining(var);
        for (Factor factor : adjFactors) {
            c.addAll((Collection)factor.varSet());
        }
        return c;
    }

    public Collection factors() {
        return Collections.unmodifiableCollection(this.factors);
    }

    public Iterator factorsIterator() {
        return this.factors().iterator();
    }

    public AssignmentIterator assignmentIterator() {
        return new DenseAssignmentIterator(this.varSet());
    }

    public Iterator varSetIterator() {
        return this.clique2ptl.keySet().iterator();
    }

    public int getIndex(Variable var) {
        int idx = var.getIndex();
        if (this.projectionMap.containsKey(idx)) {
            return this.projectionMap.get(idx);
        }
        return -1;
    }

    public int getIndex(Factor factor) {
        return this.factorsAlphabet.lookupIndex(factor, false);
    }

    public Variable get(int index) {
        int globalIdx = this.my2global[index];
        return this.universe.get(globalIdx);
    }

    public Factor getFactor(int i) {
        return (Factor)this.factorsAlphabet.lookupObject(i);
    }

    public int getDegree(Variable var) {
        return this.allFactorsContaining(var).size();
    }

    public Variable findVariable(String name) {
        Iterator it = this.variablesIterator();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (!var.getLabel().equals(name)) continue;
            return var;
        }
        return null;
    }

    public Factor factorOf(VarSet varSet) {
        switch (varSet.size()) {
            case 1: {
                return this.factorOf(varSet.get(0));
            }
            case 2: {
                return this.factorOf(varSet.get(0), varSet.get(1));
            }
        }
        return this.factorOf((Collection)varSet);
    }

    public Factor factorOf(Variable var1, Variable var2) {
        List ptls = this.allEdgeFactors(var1, var2);
        Factor ptl = this.firstIfSingleton(ptls, var1 + " " + var2);
        if (ptl != null) {
            assert (ptl.varSet().size() == 2);
            assert (ptl.containsVar(var1));
            assert (ptl.containsVar(var2));
        }
        return ptl;
    }

    private List allEdgeFactors(Variable var1, Variable var2) {
        return this.pairwiseFactors.get(this.getIndex(var1), this.getIndex(var2));
    }

    public Collection allFactorsContaining(Collection vars) {
        THashSet factors = new THashSet();
        Iterator it = this.factorsIterator();
        while (it.hasNext()) {
            Factor ptl = (Factor)it.next();
            if (!vars.containsAll(ptl.varSet())) continue;
            factors.add((Object)ptl);
        }
        return factors;
    }

    public List allFactorsContaining(Variable var) {
        return this.factorsByVar[this.getIndex(var)];
    }

    public List allFactorsOf(Variable var) {
        int idx = this.getIndex(var);
        if (idx == -1) {
            return new ArrayList();
        }
        return this.vertexPots[idx];
    }

    public List allFactorsOf(Collection c) {
        Variable v0 = (Variable)c.iterator().next();
        List factors = this.factorsByVar[this.getIndex(v0)];
        ArrayList<Factor> ret = new ArrayList<Factor>();
        for (Factor f : factors) {
            VarSet varSet = f.varSet();
            if (varSet.size() != c.size() || !c.containsAll(varSet) || !varSet.containsAll(c)) continue;
            ret.add(f);
        }
        return ret;
    }

    public void remove(Variable var) {
        this.removeFromVariableCaches(var);
        this.removeFactorsOfVariable(var);
        this.regenerateCaches();
    }

    public void remove(Collection vars) {
        for (Variable var : vars) {
            this.removeFactorsOfVariable(var);
        }
        this.numNodes -= vars.size();
        this.regenerateCaches();
    }

    public boolean isAdjacent(Variable v1, Variable v2) {
        List factors = this.allFactorsContaining(v1);
        for (Factor ptl : factors) {
            if (!ptl.varSet().contains(v2)) continue;
            return true;
        }
        return false;
    }

    public boolean containsVar(Variable v1) {
        return this.variablesSet().contains(v1);
    }

    public void addFactor(Variable var1, Variable var2, double[] probs) {
        Variable[] vars = new Variable[]{var1, var2};
        TableFactor pot = new TableFactor(vars, probs);
        this.addFactor(pot);
    }

    public void addFactor(Factor factor) {
        this.beforeFactorAdd(factor);
        VarSet varSet = factor.varSet();
        this.addVarsIfNecessary(varSet);
        this.factors.add(factor);
        this.factorsAlphabet.lookupIndex(factor);
        this.addToListMap((Map)this.clique2ptl, varSet, factor);
        this.cacheFactor(varSet, factor);
        this.afterFactorAdd(factor);
    }

    protected void beforeFactorAdd(Factor factor) {
    }

    protected void afterFactorAdd(Factor factor) {
    }

    private void addToListMap(Map map, Object key, Object value) {
        ArrayList<Object> lst = (ArrayList<Object>)map.get(key);
        if (lst == null) {
            lst = new ArrayList<Object>();
            map.put(key, lst);
        }
        lst.add(value);
    }

    private void addVarsIfNecessary(VarSet varSet) {
        for (int i = 0; i < varSet.size(); ++i) {
            Variable var = varSet.get(i);
            if (this.universe == null) {
                this.universe = var.getUniverse();
            }
            if (this.getIndex(var) >= 0) continue;
            this.cacheVariable(var);
        }
    }

    public void clear() {
        this.factorsAlphabet = new BidirectionalIntObjectMap();
        this.factors.clear();
        this.clique2ptl.clear();
        this.clearCaches();
        this.numNodes = 0;
    }

    public double factorProduct(Assignment assn) {
        Iterator ptlIter = this.factorsIterator();
        double ptlProd = 1.0;
        while (ptlIter.hasNext()) {
            ptlProd *= ((Factor)ptlIter.next()).value(assn);
        }
        return ptlProd;
    }

    public Factor factorOf(Variable var) {
        List lst = this.allFactorsOf(var);
        return this.firstIfSingleton(lst, var.toString());
    }

    private Factor firstIfSingleton(List lst, String desc) {
        if (lst == null) {
            return null;
        }
        int sz = lst.size();
        if (sz > 1) {
            throw new RuntimeException("Multiple factors over " + desc + ":\n" + CollectionUtils.dumpToString(lst, " "));
        }
        if (sz == 0) {
            return null;
        }
        return (Factor)lst.get(0);
    }

    public Factor factorOf(Collection c) {
        List factors = this.allFactorsOf(c);
        return this.firstIfSingleton(factors, c.toString());
    }

    public Factor duplicate() {
        FactorGraph dup = new FactorGraph(this.numVariables());
        try {
            for (Variable var : this.variablesSet()) {
                dup.cacheVariable(var);
            }
            Iterator it = this.factorsIterator();
            while (it.hasNext()) {
                Factor pot = (Factor)it.next();
                dup.addFactor(pot.duplicate());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dup;
    }

    public void dump() {
        this.dump(new PrintWriter((Writer)new OutputStreamWriter(System.out), true));
    }

    public void dump(PrintWriter out) {
        out.println(this);
        out.println("Factors = " + this.clique2ptl);
        for (Factor pot : this.factors) {
            out.println(pot.dumpToString());
        }
    }

    public String dumpToString() {
        StringWriter out = new StringWriter();
        this.dump(new PrintWriter(out));
        return out.toString();
    }

    public double value(Assignment assn) {
        return Math.exp(this.logValue(assn));
    }

    public double value(AssignmentIterator it) {
        return this.value(it.assignment());
    }

    public Factor normalize() {
        VariableElimination inf = new VariableElimination();
        double Z = inf.computeNormalizationFactor(this);
        this.addFactor(new ConstantFactor(1.0 / Z));
        return this;
    }

    public Factor marginalize(Variable[] vars) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Factor marginalize(Collection vars) {
        if (this.numVariables() < 5) {
            return this.asTable().marginalize(vars);
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Factor marginalize(Variable var) {
        VariableElimination inf = new VariableElimination();
        return inf.unnormalizedMarginal(this, var);
    }

    public Factor marginalizeOut(Variable var) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Factor marginalizeOut(VarSet varset) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Factor extractMax(Collection vars) {
        if (this.numVariables() < 5) {
            return this.asTable().extractMax(vars);
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Factor extractMax(Variable var) {
        if (this.numVariables() < 5) {
            return this.asTable().extractMax(var);
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Factor extractMax(Variable[] vars) {
        if (this.numVariables() < 5) {
            return this.asTable().extractMax(vars);
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    public int argmax() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Assignment sample(Randoms r) {
        Variable[] contVars = Factors.continuousVarsOf(this);
        if (contVars.length == 0 || contVars.length == this.numVariables()) {
            return this.sampleInternal(r);
        }
        Assignment paramAssn = this.sampleContinuousVars(contVars, r);
        FactorGraph discreteSliceFg = (FactorGraph)this.slice(paramAssn);
        Assignment discreteAssn = discreteSliceFg.sampleInternal(r);
        return Assignment.union(paramAssn, discreteAssn);
    }

    public Assignment sampleContinuousVars(Randoms r) {
        Variable[] contVars = Factors.continuousVarsOf(this);
        return this.sampleContinuousVars(contVars, r);
    }

    private Assignment sampleContinuousVars(Variable[] contVars, Randoms r) {
        Collection contFactors = this.allFactorsContaining(Arrays.asList(contVars));
        FactorGraph contFg = new FactorGraph(contVars);
        for (Factor factor : contFactors) {
            contFg.multiplyBy(factor);
        }
        return contFg.sampleInternal(r);
    }

    private Assignment sampleInternal(Randoms r) {
        ExactSampler sampler = new ExactSampler(r);
        return sampler.sample(this, 1);
    }

    public double sum() {
        VariableElimination inf = new VariableElimination();
        return inf.computeNormalizationFactor(this);
    }

    public double entropy() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Factor multiply(Factor dist) {
        FactorGraph fg = (FactorGraph)this.duplicate();
        fg.addFactor(dist);
        return fg;
    }

    public void multiplyBy(Factor pot) {
        this.addFactor(pot);
    }

    public void exponentiate(double power) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void divideBy(Factor pot) {
        if (!this.factors.contains(pot)) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        this.removeFactor(pot);
    }

    public VarSet varSet() {
        return new HashVarSet(this.variablesSet());
    }

    public boolean almostEquals(Factor p) {
        throw new UnsupportedOperationException();
    }

    public boolean almostEquals(Factor p, double epsilon) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public boolean isNaN() {
        for (int fi = 0; fi < this.factors.size(); ++fi) {
            if (!this.getFactor(fi).isNaN()) continue;
            return true;
        }
        return false;
    }

    public double logValue(AssignmentIterator it) {
        return this.logValue(it.assignment());
    }

    public double logValue(int loc) {
        throw new UnsupportedOperationException();
    }

    public Variable getVariable(int i) {
        return this.get(i);
    }

    public Factor slice(Assignment assn) {
        return this.slice(assn, null);
    }

    public Factor slice(Assignment assn, Map toSlicedMap) {
        return Models.addEvidence(this, assn, toSlicedMap);
    }

    public void setInferenceCache(Class inferencer, Object info) {
        this.inferenceCaches.put((Object)inferencer, info);
    }

    public Object getInferenceCache(Class inferencer) {
        return this.inferenceCaches.get((Object)inferencer);
    }

    public void logify() {
        ArrayList oldFactors = new ArrayList(this.factors);
        this.clear();
        for (AbstractTableFactor factor : oldFactors) {
            this.addFactor(new LogTableFactor(factor));
        }
    }

    public double logValue(Assignment assn) {
        Iterator ptlIter = this.factorsIterator();
        double ptlProd = 0.0;
        while (ptlIter.hasNext()) {
            ptlProd += ((Factor)ptlIter.next()).logValue(assn);
        }
        return ptlProd;
    }

    public AbstractTableFactor asTable() {
        return TableFactor.multiplyAll(this.factors).asTable();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("FactorGraph: Variables ");
        for (int i = 0; i < this.numNodes; ++i) {
            Variable var = this.get(i);
            buf.append(var);
            buf.append(",");
        }
        buf.append("\n");
        buf.append("Factors: ");
        for (Factor factor : this.factors) {
            buf.append("[");
            buf.append(factor.varSet());
            buf.append("],");
        }
        buf.append("\n");
        return buf.toString();
    }

    public void printAsDot(PrintWriter out) {
        out.println("graph model {");
        this.outputEdgesAsDot(out);
        out.println("}");
    }

    public void printAsDot(PrintWriter out, Assignment assn) {
        out.println("graph model {");
        this.outputEdgesAsDot(out);
        Iterator it = this.variablesIterator();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            int value = assn.get(var);
            String color = colors[value];
            out.println(var.getLabel() + " [style=filled fillcolor=" + color + "];");
        }
        out.println("}");
    }

    private void outputEdgesAsDot(PrintWriter out) {
        int ptlIdx = 0;
        for (Factor ptl : this.factors()) {
            VarSet vars = ptl.varSet();
            for (Variable var : vars) {
                out.print("PTL" + ptlIdx + " -- " + var.getLabel());
                out.println(";\n");
            }
            ++ptlIdx;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        in.readInt();
        this.regenerateCaches();
    }
}

