/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractBandMatrix;
import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.LowerSPDBandMatrix;
import no.uib.cipr.matrix.LowerTriangBandMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.UpperSPDBandMatrix;
import no.uib.cipr.matrix.UpperTriangBandMatrix;

public class BandCholesky {
    private final int n;
    private final int kd;
    private LowerTriangBandMatrix Cl;
    private UpperTriangBandMatrix Cu;
    private boolean notspd;
    private final boolean upper;

    public BandCholesky(int n, int kd, boolean upper) {
        this.n = n;
        this.kd = kd;
        this.upper = upper;
        if (upper) {
            this.Cu = new UpperTriangBandMatrix(n, kd);
        } else {
            this.Cl = new LowerTriangBandMatrix(n, kd);
        }
    }

    public static BandCholesky factorize(LowerSPDBandMatrix A) {
        return new BandCholesky(A.numRows(), A.kl, false).factor(A);
    }

    public static BandCholesky factorize(UpperSPDBandMatrix A) {
        return new BandCholesky(A.numRows(), A.ku, true).factor(A);
    }

    public BandCholesky factor(LowerSPDBandMatrix A) {
        if (this.upper) {
            throw new IllegalArgumentException("Cholesky decomposition constructed for upper matrices");
        }
        return this.decompose(A);
    }

    public BandCholesky factor(UpperSPDBandMatrix A) {
        if (!this.upper) {
            throw new IllegalArgumentException("Cholesky decomposition constructed for lower matrices");
        }
        return this.decompose(A);
    }

    private BandCholesky decompose(AbstractBandMatrix A) {
        if (this.n != A.numRows()) {
            throw new IllegalArgumentException("n != A.numRows()");
        }
        if (this.upper && A.ku != this.kd) {
            throw new IllegalArgumentException("A.ku != kd");
        }
        if (!this.upper && A.kl != this.kd) {
            throw new IllegalArgumentException("A.kl != kd");
        }
        this.notspd = false;
        int info = 0;
        info = this.upper ? Interface.lapack().pbtrf(BLASkernel.UpLo.Upper, this.n, this.kd, A.getData()) : Interface.lapack().pbtrf(BLASkernel.UpLo.Lower, this.n, this.kd, A.getData());
        if (info > 0) {
            this.notspd = true;
        } else if (info < 0) {
            throw new IllegalArgumentException();
        }
        if (this.upper) {
            this.Cu.set(A);
        } else {
            this.Cl.set(A);
        }
        return this;
    }

    public LowerTriangBandMatrix getL() {
        if (!this.upper) {
            return this.Cl;
        }
        throw new UnsupportedOperationException();
    }

    public UpperTriangBandMatrix getU() {
        if (this.upper) {
            return this.Cu;
        }
        throw new UnsupportedOperationException();
    }

    public boolean isSPD() {
        return !this.notspd;
    }

    public double rcond(Matrix A) {
        if (A.numRows() != this.n) {
            throw new IllegalArgumentException("A.numRows() != n");
        }
        if (!A.isSquare()) {
            throw new IllegalArgumentException("!A.isSquare()");
        }
        double anorm = A.norm(Matrix.Norm.One);
        double[] work = new double[3 * this.n];
        int[] lwork = new int[this.n];
        double[] rcond = new double[1];
        int info = 0;
        info = this.upper ? Interface.lapack().pbcon(BLASkernel.UpLo.Upper, this.n, this.kd, this.Cu.getData(), anorm, rcond, work, lwork) : Interface.lapack().pbcon(BLASkernel.UpLo.Lower, this.n, this.kd, this.Cl.getData(), anorm, rcond, work, lwork);
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return rcond[0];
    }

    public DenseMatrix solve(DenseMatrix B) throws MatrixNotSPDException {
        if (this.notspd) {
            throw new MatrixNotSPDException();
        }
        if (B.numRows() != this.n) {
            throw new IllegalArgumentException("B.numRows() != n");
        }
        int info = 0;
        info = this.upper ? Interface.lapack().pbtrs(BLASkernel.UpLo.Upper, this.n, this.kd, B.numColumns(), this.Cu.getData(), B.getData()) : Interface.lapack().pbtrs(BLASkernel.UpLo.Lower, this.n, this.kd, B.numColumns(), this.Cl.getData(), B.getData());
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return B;
    }
}

