/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.share.upenn.ner;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.Serializable;
import java.util.Arrays;

public class LengthBins
extends Pipe
implements Serializable {
    String name;
    int[] bins;
    String[] binNames;

    public LengthBins(String featureName, int[] binMaxes) {
        this.name = featureName;
        this.bins = binMaxes;
        Arrays.sort(this.bins);
        int min = 1;
        this.binNames = new String[this.bins.length + 1];
        for (int i = 0; i < this.bins.length; ++i) {
            this.binNames[i] = min == this.bins[i] ? "[" + min + "]" : "[" + min + "-" + this.bins[i] + "]";
            min = this.bins[i] + 1;
        }
        this.binNames[this.bins.length] = "[" + min + "+]";
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        block0: for (int i = 0; i < ts.size(); ++i) {
            Token t = (Token)ts.get(i);
            int length = t.getText().length();
            for (int j = 0; j < this.bins.length; ++j) {
                if (length > this.bins[j]) continue;
                t.setFeatureValue(this.name + "=" + this.binNames[j], 1.0);
                continue block0;
            }
            t.setFeatureValue(this.name + "=" + this.binNames[this.bins.length], 1.0);
        }
        return carrier;
    }
}

