/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.io.StorageFile;

final class InputStreamContainer
extends FileContainer {
    private StorageFile containerPath;

    InputStreamContainer(BaseDataFileFactory baseDataFileFactory) {
        super(baseDataFileFactory);
        this.canUpdate = false;
    }

    final boolean openContainer(ContainerKey containerKey) throws StandardException {
        FilterInputStream filterInputStream = null;
        try {
            InputStream inputStream = null;
            this.containerPath = this.dataFactory.getContainerPath(containerKey, false);
            try {
                inputStream = this.containerPath.getInputStream();
            }
            catch (IOException iOException) {
                this.containerPath = this.dataFactory.getContainerPath(containerKey, true);
                try {
                    inputStream = this.getInputStream();
                }
                catch (IOException iOException2) {
                    this.containerPath = null;
                    boolean bl = false;
                    if (filterInputStream != null) {
                        try {
                            filterInputStream.close();
                        }
                        catch (IOException iOException3) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
            }
            filterInputStream = new DataInputStream(inputStream);
            this.readHeader(this.getEmbryonicPage((DataInput)((Object)filterInputStream)));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDG3.D", iOException, (Object)this);
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    void closeContainer() {
        this.containerPath = null;
    }

    public final void clean(boolean bl) throws StandardException {
    }

    protected final int preAllocate(long l, int n) {
        return 0;
    }

    protected void truncatePages(long l) {
    }

    void createContainer(ContainerKey containerKey) throws StandardException {
    }

    protected final void removeContainer(LogInstant logInstant, boolean bl) throws StandardException {
    }

    protected final void readPage(long l, byte[] byArray) throws IOException, StandardException {
        long l2 = l * (long)this.pageSize;
        this.readPositionedPage(l2, byArray);
        if (this.dataFactory.databaseEncrypted() && l != 0L) {
            this.decryptPage(byArray, this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPositionedPage(long l, byte[] byArray) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream();
            InputStreamUtil.skipBytes(inputStream, l);
            InputStreamUtil.readFully(inputStream, byArray, 0, this.pageSize);
            inputStream.close();
            inputStream = null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected final void writePage(long l, byte[] byArray, boolean bl) throws IOException, StandardException {
    }

    protected final void flushAll() {
    }

    protected InputStream getInputStream() throws IOException {
        return this.containerPath.getInputStream();
    }

    protected void backupContainer(BaseContainerHandle baseContainerHandle, String string) throws StandardException {
        throw StandardException.newException("XSAI3.S");
    }

    protected void encryptContainer(BaseContainerHandle baseContainerHandle, String string) throws StandardException {
        throw StandardException.newException("XSAI3.S");
    }
}

